/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.util.Thunk;
import com.hds.commons.util.WorkQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SynchronousWorkQueue
implements WorkQueue {
    protected final String name;
    protected volatile boolean isRunning = true;
    protected volatile boolean blocking = true;
    private static final Logger defaultlog = Logger.getLogger(SynchronousWorkQueue.class.getName());
    protected final Logger log;

    public SynchronousWorkQueue(String name) {
        this(name, defaultlog);
    }

    public SynchronousWorkQueue(String name, Logger log) {
        this.name = name;
        this.log = log;
    }

    @Override
    public void start() {
        this.log.log(Level.INFO, "start {0}", this.name);
    }

    @Override
    public boolean enqueue(Thunk work) {
        if (this.checkStatus()) {
            work.doit();
            return true;
        }
        return false;
    }

    protected boolean checkStatus() {
        if (!this.blocking) {
            this.closeQueue();
            return false;
        }
        if (!this.isRunning) {
            this.shutdownQueue();
            return false;
        }
        return true;
    }

    protected void closeQueue() {
        LogRecord lr = new LogRecord(Level.WARNING, "Work enqueued after this queue was closed {0}");
        lr.setThrown(new RuntimeException("backtrace"));
        lr.setParameters(new Object[]{this.name});
        this.log.log(lr);
    }

    protected void shutdownQueue() {
        LogRecord lr = new LogRecord(Level.WARNING, "Work enqueued after this queue was shutdown {0}");
        lr.setThrown(new RuntimeException("backtrace"));
        lr.setParameters(new Object[]{this.name});
        this.log.log(lr);
    }

    @Override
    public Collection<Thunk> join() throws InterruptedException {
        return this.join(0L);
    }

    @Override
    public Collection<Thunk> join(long timeoutMs) throws InterruptedException {
        assert (!this.isOpen()) : " cannot join open queue " + this;
        return Collections.emptyList();
    }

    @Override
    public void shutdown() {
        this.log.log(Level.INFO, "shutdown {0}", this.name);
        this.isRunning = false;
    }

    @Override
    public void close() {
        this.log.log(Level.INFO, "Close {0}", this.name);
        this.blocking = false;
    }

    @Override
    public boolean isOpen() {
        return this.blocking && this.isRunning;
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

