/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;

public class SystemUtil {
    public static final Object STACK_TRACE_LOG_OBJECT = new Object(){

        public String toString() {
            return SystemUtil.getStackTraces();
        }
    };

    public static String getStackTraces() {
        Map<Thread, StackTraceElement[]> traceMap = Thread.getAllStackTraces();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : traceMap.entrySet()) {
            Thread th = entry.getKey();
            StackTraceElement[] trace = entry.getValue();
            builder.append(th.getName());
            builder.append("    (priority=");
            builder.append(th.getPriority());
            builder.append(", id=");
            builder.append(th.getId());
            builder.append(", state=");
            builder.append((Object)th.getState());
            builder.append(")\n");
            for (StackTraceElement stackElem : trace) {
                builder.append("    ");
                builder.append(stackElem.toString());
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    public static String getDeadlocks() {
        long[] deadlocked;
        StringBuilder sb = new StringBuilder();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] lArray = deadlocked = threadBean.isSynchronizerUsageSupported() ? threadBean.findDeadlockedThreads() : threadBean.findMonitorDeadlockedThreads();
        if (deadlocked != null) {
            for (long threadid : deadlocked) {
                ThreadInfo info = threadBean.getThreadInfo(threadid);
                sb.append(info.toString());
            }
        }
        return sb.toString();
    }

    public static String getThreadTimes() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        if (threadBean.isThreadCpuTimeSupported()) {
            long[] threadIds;
            for (long threadId : threadIds = threadBean.getAllThreadIds()) {
                long cpuTime = threadBean.getThreadCpuTime(threadId) / 1000000L;
                sb.append(String.format("%4d %12d msec\n", threadId, cpuTime));
            }
        }
        return sb.toString();
    }
}

