/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.HdsCommonsConfig;
import com.hds.commons.util.Thunk;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TracingThunk
implements Thunk {
    static final Logger log = Logger.getLogger(TracingThunk.class.getName());
    private final Thunk delegate;
    private final Throwable t = new RuntimeException("enqueue");

    public static Thunk create(Thunk delegate) {
        if (HdsCommonsConfig.isBacktraceEnabled()) {
            return new TracingThunk(delegate);
        }
        return delegate;
    }

    protected TracingThunk(Thunk delegate) {
        this.delegate = delegate;
    }

    @Override
    public void doit() {
        try {
            this.delegate.doit();
        }
        catch (Error k) {
            try {
                this.setCause(this.getRoot(k), this.t);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "cant set backtrace ", this.t);
            }
            throw k;
        }
        catch (RuntimeException k) {
            try {
                this.setCause(this.getRoot(k), this.t);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "cant set backtrace ", this.t);
            }
            throw k;
        }
    }

    Throwable getRoot(Throwable k) {
        Throwable c = k.getCause();
        if (c == null) {
            return k;
        }
        if (c == k) {
            return c;
        }
        return this.getRoot(c);
    }

    void setCause(Throwable t, Throwable c) throws NoSuchFieldException, IllegalAccessException {
        Field field = Throwable.class.getDeclaredField("cause");
        field.setAccessible(true);
        field.set(t, c);
    }
}

