/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.ctc.wstx.io.TextEscaper;
import com.google.common.collect.Maps;
import com.hds.commons.util.ParserHelper;
import com.hds.commons.util.logging.RISLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLUtils {
    private static final RISLogger log = RISLogger.getLogger();

    public static Map<String, String> toMap(InputStream in) throws IOException {
        LinkedHashMap map = Maps.newLinkedHashMap();
        try {
            XMLStreamReader xmlReader = ParserHelper.getInputFactory().createXMLStreamReader(in);
            String name = null;
            String value = null;
            int eventType = xmlReader.getEventType();
            while (eventType != 8) {
                if (eventType == 1) {
                    name = xmlReader.getLocalName();
                    value = null;
                } else if (eventType == 2) {
                    if (name != null) {
                        map.put(name, value);
                    }
                    name = null;
                    value = null;
                } else if (eventType == 4 && name != null) {
                    value = xmlReader.getText();
                }
                eventType = xmlReader.next();
            }
            xmlReader.close();
        }
        catch (XMLStreamException ex) {
            throw (IOException)new IOException("Exception while serializing metadata to XML").initCause(ex);
        }
        return map;
    }

    public static String escape(String str) {
        try {
            StringWriter stringWriter = new StringWriter();
            TextEscaper.writeEscapedAttrValue((Writer)stringWriter, (String)str);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "", e);
            return null;
        }
    }

    public static String escapeAttributeText(String str) {
        try {
            StringWriter stringWriter = new StringWriter(str.length());
            TextEscaper.writeEscapedAttrValue((Writer)stringWriter, (String)str);
            stringWriter.close();
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "", e);
            return null;
        }
    }

    public static void openElement(String elementName, String attrName, String attrValue, StringBuffer buf) {
        buf.append('<').append(elementName).append(' ').append(attrName).append('=').append('\"');
        buf.append(attrValue).append('\"').append('>');
    }

    public static void openElement(String elementName, StringBuffer buf) {
        buf.append('<').append(elementName).append('>');
    }

    public static void closeElement(String elementName, StringBuffer buf) {
        buf.append('<').append('/').append(elementName).append('>');
    }

    public static void addElement(String elementName, String elementValue, StringBuffer buf) {
        XMLUtils.openElement(elementName, buf);
        buf.append(elementValue);
        XMLUtils.closeElement(elementName, buf);
    }

    public static void addCDATAElement(String elementName, String elementValue, StringBuffer buf) {
        if (elementValue.indexOf("]]") > -1) {
            elementValue = elementValue.substring(0, elementValue.indexOf(93));
        }
        XMLUtils.openElement(elementName, buf);
        buf.append("<![CDATA[");
        buf.append(elementValue);
        buf.append("]]>");
        XMLUtils.closeElement(elementName, buf);
    }
}

