/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import com.hds.commons.util.Pool;
import com.hds.commons.util.SimpleWorkQueue;
import com.hds.commons.util.SortedLimitedPool;
import com.hds.commons.util.logging.FixedLogger;
import com.hds.commons.util.logging.LogConfiguration;
import com.hds.commons.util.logging.RISFormatter;
import com.hds.commons.util.logging.RISLogRecord;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FileHandler
extends Handler {
    static final LogConfiguration config = new LogConfiguration(FileHandler.class);
    static final Charset charset = config.getEncoder();
    private static String nodeNumber;
    private static String jvmName;
    private static String namePrefix;
    protected boolean isOpen = true;
    private static final Logger localLog;
    static final int FINEST = 300;
    static final int FINER = 400;
    static final int FINE = 500;
    static final int CONFIG = 700;
    static final int INFO = 800;
    static final int WARNING = 900;
    static final int SEVERE = 1000;
    protected final SimpleWorkQueue backlog;
    static final boolean UseMemoryBacklog = false;
    static final int FileWriterCount = 10;
    static final int backlogSize = 500;
    private static final int HELPER_COUNT = 7;
    static final Pool<Helper>[] helpers;

    public static void setup() {
    }

    public static synchronized void init(String nodeNumber, String jvmName, String logDir) {
        FileHandler.nodeNumber = nodeNumber;
        FileHandler.jvmName = jvmName;
        namePrefix = logDir + File.separatorChar + jvmName + '.' + nodeNumber + '.';
        localLog.log(Level.CONFIG, "Node {0} jvm {1} and log dir {2}", new Object[]{nodeNumber, jvmName, logDir});
        for (Pool<Helper> helper : helpers) {
            helper.initialize();
        }
    }

    public FileHandler() {
        Level l = config.getLevel();
        if (l != null) {
            this.setLevel(l);
        }
        this.setFilter(config.getFilter());
        this.setErrorManager(config.getErrorManager());
        this.backlog = null;
    }

    private static Pool<Helper> getHelpers(Level level) {
        switch (level.intValue()) {
            case 300: {
                return helpers[0];
            }
            case 400: {
                return helpers[1];
            }
            case 500: {
                return helpers[2];
            }
            case 800: {
                return helpers[3];
            }
            case 700: {
                return helpers[4];
            }
            case 900: {
                return helpers[5];
            }
            case 1000: {
                return helpers[6];
            }
        }
        assert (false) : "cant happen";
        return helpers[0];
    }

    private static String getLevelString(int level) {
        switch (level) {
            case 0: {
                return Level.FINEST.toString();
            }
            case 1: {
                return Level.FINER.toString();
            }
            case 2: {
                return Level.FINE.toString();
            }
            case 3: {
                return Level.INFO.toString();
            }
            case 4: {
                return Level.CONFIG.toString();
            }
            case 5: {
                return Level.WARNING.toString();
            }
            case 6: {
                return Level.SEVERE.toString();
            }
        }
        assert (false) : "cant happen " + level;
        return "impossible";
    }

    @Override
    public Formatter getFormatter() {
        return FileHandler.getHelpers(Level.INFO).get().getFormatter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            if (!this.isOpen) {
                Class<FileHandler> clazz = FileHandler.class;
                synchronized (FileHandler.class) {
                    localLog.log(record);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            this.publishWithHelp(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishWithHelp(LogRecord record) {
        Pool<Helper> pool = FileHandler.getHelpers(record.getLevel());
        Helper helper = pool.get();
        try {
            helper.publish(record);
        }
        finally {
            pool.put(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollLogFiles() {
        RISLogRecord lr = new RISLogRecord(Level.ALL, "Roll Log Entry");
        Pool<Helper>[] poolArray = helpers;
        synchronized (helpers) {
            for (Pool<Helper> helper2 : helpers) {
                for (Helper helper : helper2.all()) {
                    if (!helper.hasOut()) continue;
                    helper.publish(lr);
                    helper.faulureReported = false;
                    helper.close();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized void close() {
        localLog.log(Level.INFO, "Closing all logs.");
        this.isOpen = false;
        FileHandler.rollLogFiles();
        localLog.log(Level.INFO, "Closed and flushed all logs");
    }

    @Override
    public void flush() {
    }

    static {
        helpers = new Pool[7];
        ConsoleHandler h = new ConsoleHandler();
        h.setFormatter(new RISFormatter());
        h.setLevel(Level.ALL);
        localLog = FixedLogger.create(FileHandler.class.getName() + ".Impl", h);
        localLog.setUseParentHandlers(false);
        for (int i = 0; i < helpers.length; ++i) {
            final int myLevel = i;
            FileHandler.helpers[i] = new SortedLimitedPool<Helper>(10, 0, "Log file handlers", true, localLog){

                @Override
                protected Helper allocateResource() {
                    return new Helper(myLevel);
                }
            };
        }
    }

    private static class Helper
    implements Comparable<Helper> {
        static final int MIN_BUFFER_SIZE = 512;
        protected static int[] instanceNumber = new int[7];
        protected final Integer instance;
        protected final CharsetEncoder encoder = charset.newEncoder();
        private Formatter formatter = config.getFormatter();
        private boolean first;
        private boolean blockRecursion;
        final String levelString;
        private static final boolean TESTING = Boolean.getBoolean("testing");
        private final boolean logStats;
        protected WritableByteChannel out;
        static LogRecord oldRecord;
        protected volatile boolean faulureReported;
        protected ByteBuffer tempBuffer = ByteBuffer.allocateDirect(512);

        @Override
        public int compareTo(Helper o) {
            return this.instance.compareTo(o.instance);
        }

        private Helper(int level) {
            this(level, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Helper(int level, boolean logStats) {
            this.levelString = FileHandler.getLevelString(level);
            this.logStats = logStats;
            Class<FileHandler> clazz = FileHandler.class;
            synchronized (FileHandler.class) {
                if (jvmName == null && nodeNumber == null) {
                    if (!TESTING) {
                        localLog.log(Level.SEVERE, "FileHandler.init() was not called before the first use of this class. Will use 'jvm0' and node '0' and log dir './logs/'", new RuntimeException("call stack"));
                    }
                    FileHandler.init("0", "jvm0", "./logs/");
                }
                int n = level;
                int n2 = instanceNumber[n];
                instanceNumber[n] = n2 + 1;
                this.instance = n2;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public Formatter getFormatter() {
            return this.formatter;
        }

        public synchronized boolean hasOut() {
            return this.out != null;
        }

        protected synchronized WritableByteChannel getOut() {
            block4: {
                if (this.out == null) {
                    Path path = null;
                    try {
                        path = Paths.get(this.getFilename(), new String[0]);
                        Path pf = path.getParent();
                        Files.createDirectories(pf, new FileAttribute[0]);
                        this.out = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                        if (!this.faulureReported) {
                            localLog.log(Level.CONFIG, "logging to file {0}", path.toAbsolutePath().normalize());
                        }
                    }
                    catch (IOException e) {
                        if (this.faulureReported) break block4;
                        this.faulureReported = true;
                        localLog.log(Level.SEVERE, "cant open log file {0} because {1}", new Object[]{this.getFilename(), e});
                    }
                }
            }
            return this.out;
        }

        protected String getFilename() {
            return this.getFilename(this.instance);
        }

        private String getFilename(Integer instance) {
            return this.getFilename(this.levelString, instance);
        }

        private String getFilename(String aString, Integer instance) {
            return namePrefix + instance + '.' + aString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void publish(LogRecord record) {
            if (this.logStats && record.getSequenceNumber() % 10000L == 0L) {
                if (oldRecord == null) {
                    oldRecord = record;
                } else {
                    System.out.println((float)(record.getSequenceNumber() - oldRecord.getSequenceNumber()) / (float)(record.getMillis() - oldRecord.getMillis()) * 1000.0f);
                    oldRecord = record;
                }
            }
            if (this.blockRecursion) {
                return;
            }
            this.blockRecursion = true;
            try {
                if (this.first) {
                    this.first = false;
                }
                try {
                    Formatter formatter = this.getFormatter();
                    CharSequence log = formatter instanceof RISFormatter ? ((RISFormatter)formatter).formatToChars(record) : formatter.format(record);
                    this.publish(log, record);
                }
                catch (Exception e) {
                    RISLogRecord lr = new RISLogRecord(Level.SEVERE, "Unable to format log record {0}. Writing unformatted.");
                    lr.setParameters(new Object[]{record.getMessage()});
                    lr.setThrown(e);
                    localLog.log(lr);
                    this.publish(record.getMessage(), record);
                }
            }
            finally {
                this.blockRecursion = false;
            }
        }

        private void publish(CharSequence message, LogRecord lr) {
            block9: {
                WritableByteChannel localOut = this.getOut();
                if (localOut != null) {
                    ByteBuffer byteBuffer = this.encode(message);
                    try {
                        this.actuallyWrite(localOut, byteBuffer);
                    }
                    catch (IOException e) {
                        if (!this.faulureReported) {
                            localLog.log(Level.WARNING, "File logging failed for record {0,number,0000000} with {1} Will retry", new Object[]{lr.getSequenceNumber(), e.toString()});
                        }
                        this.close();
                        localOut = this.getOut();
                        if (localOut != null) {
                            try {
                                localOut.write(byteBuffer);
                            }
                            catch (IOException e1) {
                                if (!this.faulureReported) {
                                    localLog.log(Level.WARNING, "File logging failed. Will log to system.out. With reset level.", e);
                                    this.faulureReported = true;
                                }
                                lr.setLevel(localLog.getLevel());
                                localLog.log(lr);
                            }
                            this.faulureReported = true;
                            break block9;
                        }
                        localLog.log(lr);
                    }
                } else {
                    localLog.log(lr);
                }
            }
        }

        private void actuallyWrite(WritableByteChannel localOut, ByteBuffer message) throws IOException {
            try {
                localOut.write(message);
            }
            catch (ClosedByInterruptException e) {
                Thread.interrupted();
                this.close();
                localOut = this.getOut();
                if (localOut != null) {
                    localOut.write(message);
                }
                throw e;
            }
        }

        protected ByteBuffer encode(CharSequence value) {
            return this.encode(CharBuffer.wrap(value));
        }

        protected ByteBuffer encode(CharBuffer value) {
            ByteBuffer tempBuffer = this.getTempBuffer(value.length());
            this.encoder.encode(value, tempBuffer, true);
            tempBuffer.flip();
            return tempBuffer;
        }

        protected ByteBuffer getTempBuffer(int size) {
            if (size > this.tempBuffer.capacity()) {
                this.tempBuffer = ByteBuffer.allocateDirect(size);
                return this.tempBuffer;
            }
            this.tempBuffer.clear();
            return this.tempBuffer;
        }

        public synchronized void close() {
            if (this.out != null) {
                try {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        localLog.log(Level.WARNING, "Cannot close log", e);
                    }
                }
                finally {
                    this.out = null;
                    this.formatter = config.getFormatter();
                }
            } else {
                localLog.log(Level.INFO, "closed file handler that was not open");
            }
        }
    }
}

