/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import com.hds.commons.util.logging.LogManagerHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.logging.Filter;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class FilteringLogManager
extends LogManager {
    private static final String FILTER_CONFIG = ".filter";
    private static final String FILTER_ARGS_CONFG = ".filterArguments";
    private static final String INHERT_FILTER_CONFIG = ".inheritFilter";
    private final Object inheritenceLock = new Object();
    private volatile boolean replaceSystemProperties = true;

    @Override
    public boolean addLogger(Logger logger) {
        this.forceParentsWithConfigToExist(logger);
        boolean result = super.addLogger(logger);
        this.inheritOrCreateFilter(logger);
        return result;
    }

    @Override
    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        super.readConfiguration(ins);
        this.replaceSystemProperties = LogManagerHelper.getBooleanProperty(this, this.getClass().getName() + ".replaceSystemProperties", true);
        this.rebuildFilterInheritenceTree();
    }

    @Override
    public String getProperty(String name) {
        String result = super.getProperty(name);
        if (result != null && this.replaceSystemProperties) {
            result = FilteringLogManager.replace(result);
        }
        return result;
    }

    protected static String replace(String input) {
        String result = input;
        StringBuilder sb = null;
        int endIndex = 0;
        int index = input.indexOf("${");
        while (index >= 0) {
            if (sb == null) {
                sb = new StringBuilder(input.length());
            }
            sb.append(input, endIndex, index);
            endIndex = input.indexOf(125, index + 2);
            if (endIndex < 0) {
                endIndex = index;
                break;
            }
            String value = null;
            int subStart = index + 2;
            if (subStart < endIndex) {
                String key = input.substring(index + 2, endIndex);
                value = System.getProperty(key);
            }
            ++endIndex;
            if (value == null) {
                sb.append(input, index, endIndex);
            } else {
                sb.append(value);
            }
            index = input.indexOf("${", endIndex);
        }
        if (sb != null) {
            result = sb.append(input, endIndex, input.length()).toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inheritOrCreateFilter(Logger logger) {
        Filter filter = logger.getFilter();
        if (filter != null) {
            return;
        }
        Object object = this.inheritenceLock;
        synchronized (object) {
            String filterArguments = this.getFilterArguments(logger);
            ArrayList<Logger> familyMembers = null;
            for (Logger familyMember = logger; filter == null && familyMember != null && this.canInheritFilter(familyMember); familyMember = familyMember.getParent()) {
                Class<Filter> filterClass = null;
                filter = familyMember.getFilter();
                if (filter == null) {
                    filterClass = this.getFilterClass(familyMember);
                    if (filterArguments == null) {
                        filterArguments = this.getFilterArguments(familyMember);
                        if (familyMembers == null) {
                            familyMembers = new ArrayList<Logger>();
                        }
                        familyMembers.add(familyMember);
                    }
                } else if (filterArguments != null) {
                    filterClass = filter.getClass();
                }
                if (filterClass == null) continue;
                filter = this.createFilter(filterClass, filterArguments);
            }
            if (filter != null) {
                logger.setFilter(filter);
                if (familyMembers != null && !familyMembers.isEmpty()) {
                    for (Logger ancestor : familyMembers) {
                        ancestor.setFilter(filter);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildFilterInheritenceTree() {
        Object object = this.inheritenceLock;
        synchronized (object) {
            TreeSet<String> loggers = new TreeSet<String>();
            Enumeration<String> e = this.getLoggerNames();
            while (e.hasMoreElements()) {
                loggers.add(e.nextElement());
            }
            String inheritUnderName = null;
            Filter currentFilter = null;
            for (String loggerName : loggers) {
                Logger parent;
                Logger logger = this.getLogger(loggerName);
                if (logger == null) continue;
                boolean canInherit = this.canInheritFilter(logger);
                boolean createdParents = this.forceParentsWithConfigToExist(logger);
                if (!(currentFilter == null || !createdParents && canInherit && loggerName.startsWith(inheritUnderName))) {
                    currentFilter = null;
                    inheritUnderName = null;
                }
                if (canInherit && currentFilter == null && (parent = logger.getParent()) != null && (currentFilter = parent.getFilter()) != null) {
                    inheritUnderName = this.getStartswithForChildren(parent.getName());
                }
                String filterArgs = this.getFilterArguments(logger);
                Class<Filter> filterClass = this.getFilterClass(logger);
                if (filterClass == null && currentFilter != null && filterArgs != null) {
                    filterClass = currentFilter.getClass();
                }
                if (filterClass != null) {
                    currentFilter = this.createFilter(filterClass, filterArgs);
                    inheritUnderName = this.getStartswithForChildren(loggerName);
                }
                logger.setFilter(currentFilter);
            }
        }
    }

    private String getStartswithForChildren(String name) {
        return name.isEmpty() ? name : name + '.';
    }

    private Filter createFilter(Class<? extends Filter> filterClass, String argumentsString) {
        Filter filter = null;
        Object[] arguments = argumentsString != null && !argumentsString.isEmpty() ? argumentsString.split("\\s+") : new Object[]{};
        Object[] parameterTypes = new Class[arguments.length];
        Arrays.fill(parameterTypes, String.class);
        try {
            filter = filterClass.getConstructor((Class<?>[])parameterTypes).newInstance(arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filter;
    }

    private Class<Filter> getFilterClass(Logger logger) {
        Class<?> filterClass = null;
        String className = LogManagerHelper.getStringProperty(this, logger.getName() + FILTER_CONFIG, null);
        if (className != null) {
            try {
                filterClass = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return filterClass;
    }

    private String getFilterArguments(Logger logger) {
        return LogManagerHelper.getStringProperty(this, logger.getName() + FILTER_ARGS_CONFG, null);
    }

    private boolean canInheritFilter(Logger logger) {
        return LogManagerHelper.getBooleanProperty(this, logger.getName() + INHERT_FILTER_CONFIG, true);
    }

    private boolean forceParentsWithConfigToExist(Logger logger) {
        boolean result = false;
        String name = logger.getName();
        int lastIndex = name.lastIndexOf(46);
        int index = name.indexOf(46);
        while (index > 0 && index <= lastIndex) {
            String subName = name.substring(0, index);
            if (this.anyFilterConfigurationExists(subName) && this.getLogger(subName) == null) {
                Logger.getLogger(subName);
                result = true;
            }
            index = name.indexOf(46, index + 1);
        }
        return result;
    }

    private boolean anyFilterConfigurationExists(String name) {
        return this.getProperty(name + FILTER_CONFIG) != null || this.getProperty(name + FILTER_ARGS_CONFG) != null || this.getProperty(name + INHERT_FILTER_CONFIG) != null;
    }
}

