/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import com.hds.commons.util.EmptyResourceBundle;
import com.hds.commons.util.logging.FixedLogger;
import com.hds.commons.util.logging.NothingFilter;
import com.hds.commons.util.logging.RISFormatter;
import com.hds.commons.util.logging.RISLogRecord;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogConfiguration {
    static final String FORMATTER_PROPERTY_SUFFIX = "formatter";
    static final String LEVEL_PROPERTY_SUFFIX = "level";
    static final String ERROR_MANAGER_PROPERTY_SUFFIX = "error-manager";
    static final String ENCODING_PROPERTY_SUFFIX = "encoding";
    static final String FILTER_PROPERTY_SUFFIX = "filter";
    static final Level DEFAULT_LEVEL = Level.ALL;
    static final String DEFAULT_ERROR_MANAGER = "java.util.logging.ErrorManager";
    static final String DEFAULT_ENCODING = "UTF-8";
    static final Charset DEFAULT_ENCODER = Charset.forName("UTF-8");
    static final Filter DEFAULT_FILTER = NothingFilter.singleton;
    protected final String owner;
    private static ResourceBundle resources;
    private static final Logger log;
    private static String root;

    public static void init(String logFormatFile) {
        root = logFormatFile;
        try {
            resources = ResourceBundle.getBundle(root, LogConfiguration.getLocale());
        }
        catch (NullPointerException e) {
            log.log(Level.CONFIG, "No root name that can be used to locate resource bundle specified.");
            resources = EmptyResourceBundle.singleton;
        }
        catch (MissingResourceException e) {
            log.log(Level.CONFIG, "No resource bundle found for {0}. Will try reading as filename", root);
            try {
                resources = new PropertyResourceBundle(new BufferedInputStream(new FileInputStream(root)));
            }
            catch (IOException x) {
                log.log(Level.CONFIG, "No file named {0}. Using empty resource bundle", root);
                resources = EmptyResourceBundle.singleton;
            }
        }
    }

    public LogConfiguration(Class<?> owner) {
        this(owner.getName());
    }

    LogConfiguration(String owner) {
        this.owner = owner;
    }

    ResourceBundle getResources() {
        if (resources == null) {
            return EmptyResourceBundle.singleton;
        }
        return resources;
    }

    private String getFullPropertyName(String propertyName) {
        return this.owner + "." + propertyName;
    }

    static Locale getLocale() {
        Locale locale = null;
        while (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    String getProperty(String propertyName, String def) {
        String fullPropertyName = this.getFullPropertyName(propertyName);
        String property = LogManager.getLogManager().getProperty(fullPropertyName);
        if (property != null) {
            return property;
        }
        Object[] args = new String[]{this.owner, fullPropertyName, def};
        log.log(Level.CONFIG, "No property named {1} found for {0} using {2}.", args);
        return def;
    }

    String getProperty(String propertyName) {
        String fullPropertyName = this.getFullPropertyName(propertyName);
        String property = LogManager.getLogManager().getProperty(fullPropertyName);
        if (property != null) {
            return property;
        }
        Object[] args = new String[]{this.owner, fullPropertyName};
        log.log(Level.CONFIG, "No property named {1} found for {0} using default.", args);
        return null;
    }

    private void propertyValueError(String propertyName, String value, String def, Exception e) {
        Object[] args = new String[]{this.owner, this.getFullPropertyName(propertyName), value, def};
        RISLogRecord r = new RISLogRecord(Level.CONFIG, "Handler property {1} value of {2} set for {0} is invalid, using default {3}");
        r.setParameters(args);
        r.setThrown(e);
        log.log(r);
    }

    Level getLevel() {
        String levelName = this.getProperty(LEVEL_PROPERTY_SUFFIX);
        if (levelName == null) {
            return DEFAULT_LEVEL;
        }
        try {
            return Level.parse(levelName);
        }
        catch (IllegalArgumentException e) {
            this.propertyValueError(LEVEL_PROPERTY_SUFFIX, levelName, DEFAULT_LEVEL.toString(), e);
            return DEFAULT_LEVEL;
        }
    }

    Filter getFilter() {
        String filterName = this.getProperty(FILTER_PROPERTY_SUFFIX);
        if (filterName == null) {
            return DEFAULT_FILTER;
        }
        try {
            return (Filter)this.getInstance(filterName, FILTER_PROPERTY_SUFFIX, (Object)DEFAULT_FILTER);
        }
        catch (ClassCastException e) {
            this.propertyValueError(FILTER_PROPERTY_SUFFIX, filterName, DEFAULT_FILTER.getClass().getName(), e);
            return DEFAULT_FILTER;
        }
    }

    private Object getInstance(String className, String propertyName) {
        return this.getInstance(className, propertyName, null);
    }

    private Object getInstance(String className, String propertyName, Object def) {
        try {
            return this.getInstance(Class.forName(className), propertyName, def);
        }
        catch (ClassNotFoundException e) {
            this.propertyValueError(propertyName, className, def.getClass().getName(), e);
            return def;
        }
    }

    private Object getInstance(Class<?> aClass, String propertyName, Object def) {
        try {
            return aClass.newInstance();
        }
        catch (IllegalAccessException e) {
            this.propertyValueError(propertyName, aClass.getName(), def.getClass().getName(), e);
        }
        catch (InstantiationException e) {
            this.propertyValueError(propertyName, aClass.getName(), def.getClass().getName(), e);
        }
        return def;
    }

    Formatter getFormatter() {
        Formatter formatter;
        String formatterName = this.getProperty(FORMATTER_PROPERTY_SUFFIX);
        if (formatterName != null && (formatter = (Formatter)this.getInstance(formatterName, FORMATTER_PROPERTY_SUFFIX)) != null) {
            return formatter;
        }
        return new RISFormatter();
    }

    ErrorManager getErrorManager() {
        String managerName = this.getProperty(ERROR_MANAGER_PROPERTY_SUFFIX);
        if (managerName != null) {
            return (ErrorManager)this.getInstance(managerName, ERROR_MANAGER_PROPERTY_SUFFIX);
        }
        return (ErrorManager)this.getInstance(DEFAULT_ERROR_MANAGER, ERROR_MANAGER_PROPERTY_SUFFIX);
    }

    String getEncoding() {
        return this.getProperty(ENCODING_PROPERTY_SUFFIX, DEFAULT_ENCODING);
    }

    Charset getEncoder() {
        String charsetName = this.getProperty(ENCODING_PROPERTY_SUFFIX, DEFAULT_ENCODING);
        if (charsetName != null && charsetName != DEFAULT_ENCODING) {
            try {
                return Charset.forName(charsetName);
            }
            catch (IllegalCharsetNameException e) {
                this.propertyValueError(ENCODING_PROPERTY_SUFFIX, charsetName, DEFAULT_ENCODER.getClass().getName(), e);
            }
            catch (UnsupportedCharsetException e) {
                this.propertyValueError(ENCODING_PROPERTY_SUFFIX, charsetName, DEFAULT_ENCODER.getClass().getName(), e);
            }
        }
        return DEFAULT_ENCODER;
    }

    MessageFormat getLocalFormatter(String name, String def) {
        String format = this.getLocalMessage(name, def);
        try {
            return new MessageFormat(format, LogConfiguration.getLocale());
        }
        catch (IllegalArgumentException e) {
            Object[] args = new String[]{this.owner, LogConfiguration.getLocale().toString(), format, def};
            RISLogRecord r = new RISLogRecord(Level.WARNING, "Invalid message format {2} found for {0} locale {1}. Using default {3}.");
            r.setParameters(args);
            r.setThrown(e);
            log.log(r);
            try {
                return new MessageFormat(def, LogConfiguration.getLocale());
            }
            catch (IllegalArgumentException x) {
                assert (false) : "The hard-coded message format is invalid: " + def;
                return null;
            }
        }
    }

    public MessageFormat getFormatter(String format) {
        try {
            return new MessageFormat(this.getLocalMessage(format), LogConfiguration.getLocale());
        }
        catch (IllegalArgumentException e) {
            Object[] args = new String[]{this.owner, LogConfiguration.getLocale().toString(), this.getLocalMessage(format), format};
            RISLogRecord r = new RISLogRecord(Level.WARNING, "Invalid message format {2} found for {0} locale {1}. Using default {3}.");
            r.setParameters(args);
            log.log(r);
            try {
                return new MessageFormat(format, LogConfiguration.getLocale());
            }
            catch (IllegalArgumentException x) {
                log.log(Level.SEVERE, "The hard-coded message format is invalid: {0}", format);
                return null;
            }
        }
    }

    String getLocalMessage(String name, String def) {
        try {
            return this.getResources().getString(name);
        }
        catch (MissingResourceException e) {
            if (resources != EmptyResourceBundle.singleton && log.isLoggable(Level.CONFIG)) {
                Object[] args = new String[]{this.owner, LogConfiguration.getLocale().getDisplayName(), name, def};
                log.log(Level.CONFIG, "No local message \"{2}\" found for \"{0}\" in locale {1}. Using default \"{3}\".", args);
            }
            return def;
        }
    }

    String getLocalMessage(String message) {
        return this.getLocalMessage(message, message);
    }

    static {
        ConsoleHandler h = new ConsoleHandler();
        h.setFormatter(new SimpleFormatter());
        h.setLevel(Level.ALL);
        log = FixedLogger.create(LogConfiguration.class.getName(), h);
        log.setUseParentHandlers(false);
    }
}

