/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class LogManagerHelper {
    public static String getStringProperty(String name, String defaultValue) {
        return LogManagerHelper.getStringProperty(LogManager.getLogManager(), name, defaultValue);
    }

    public static String getStringProperty(LogManager manager, String name, String defaultValue) {
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    public static Level getLevelProperty(String name, Level defaultValue) {
        return LogManagerHelper.getLevelProperty(LogManager.getLogManager(), name, defaultValue);
    }

    public static Level getLevelProperty(LogManager manager, String name, Level defaultValue) {
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Filter getFilterProperty(String name, Filter defaultValue) {
        return LogManagerHelper.getFilterProperty(LogManager.getLogManager(), name, defaultValue);
    }

    public static Filter getFilterProperty(LogManager manager, String name, Filter defaultValue) {
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static int getIntProperty(String name, int defaultValue) {
        return LogManagerHelper.getIntProperty(LogManager.getLogManager(), name, defaultValue);
    }

    public static int getIntProperty(LogManager manager, String name, int defaultValue) {
        int value = defaultValue;
        String stringValue = manager.getProperty(name);
        if (stringValue != null) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static long getLongProperty(String name, int defaultValue) {
        return LogManagerHelper.getIntProperty(LogManager.getLogManager(), name, defaultValue);
    }

    public static long getLongProperty(LogManager manager, String name, int defaultValue) {
        long value = defaultValue;
        String stringValue = manager.getProperty(name);
        if (stringValue != null) {
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        return LogManagerHelper.getBooleanProperty(LogManager.getLogManager(), name, defaultValue);
    }

    public static boolean getBooleanProperty(LogManager manager, String name, boolean defaultValue) {
        boolean value = defaultValue;
        String stringValue = manager.getProperty(name);
        if (stringValue != null) {
            value = Boolean.parseBoolean(stringValue);
        }
        return value;
    }
}

