/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import com.hds.commons.cache.SimpleLRUCache;
import com.hds.commons.util.logging.LogConfiguration;
import com.hds.commons.util.logging.RISLogRecord;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class RISFormatter
extends Formatter {
    static final String DEFAULT_RECORD_FORMAT = "{0,number,00000000} {1, date} {1, time} logger: {2} at {3}.{4}({5}:{6, number,####}) thread:{7} severity:{8} value:{9, number, 0000} message: {10} \n{11}";
    static final String DEFAULT_EXCEPTION_FORMAT = "{0,number,00000000} {11,number,00}                                           {12} {13}\n{14}";
    static final String DEFAULT_STACK_ELEMENT_FORMAT = "{0,number,00000000} {11, number,00}                                                     at {12}.{13}({14}:{15, number,####})\n";
    static final String DEFAULT_DESCRIPTION_FORMAT = "{0,number,00000000} {11,number,00}                                                  {12}\n";
    static final LogConfiguration config;
    final Pattern lineBreak = Pattern.compile("\n");
    MessageFormat recordFormatter;
    MessageFormat exceptionFormatter;
    MessageFormat stackElementFormatter;
    MessageFormat descriptionFormatter;
    private static final Integer MINUS_ONE;
    static final int MAXIMUM_CACHED_FORMATTERS = 1000;
    final Map<String, MessageFormat> formatCache = Collections.synchronizedMap(new SimpleLRUCache(1000));
    static final int otherPartsSize = 11;
    static final Object[] nonParts;

    public MessageFormat getExceptionFormatter() {
        if (this.exceptionFormatter != null) {
            return this.exceptionFormatter;
        }
        this.exceptionFormatter = config.getLocalFormatter("exception-format", DEFAULT_EXCEPTION_FORMAT);
        return this.exceptionFormatter;
    }

    public MessageFormat getRecordFormatter() {
        if (this.recordFormatter != null) {
            return this.recordFormatter;
        }
        this.recordFormatter = config.getLocalFormatter("record-format", DEFAULT_RECORD_FORMAT);
        return this.recordFormatter;
    }

    public MessageFormat getStackElementFormatter() {
        if (this.stackElementFormatter != null) {
            return this.stackElementFormatter;
        }
        this.stackElementFormatter = config.getLocalFormatter("stack-frame-format", DEFAULT_STACK_ELEMENT_FORMAT);
        return this.stackElementFormatter;
    }

    public MessageFormat getDescriptionFormatter() {
        if (this.descriptionFormatter != null) {
            return this.descriptionFormatter;
        }
        this.descriptionFormatter = config.getLocalFormatter("description-format", DEFAULT_DESCRIPTION_FORMAT);
        return this.descriptionFormatter;
    }

    @Override
    public String format(LogRecord record) {
        return new String(this.formatToChars(record));
    }

    MessageFormat getFormatter(String format, Object[] params) {
        MessageFormat formatter = this.formatCache.get(format);
        if (formatter == null) {
            int count;
            int n = count = params == null ? 0 : params.length;
            if (format.split("\\{").length - 1 != count) {
                List<Object> list = params == null ? Collections.emptyList() : Arrays.asList(params);
                Thread.dumpStack();
                System.out.println("Message format has " + (format.split("\\{").length - 1) + " parameters but only " + count + " have been provided. Message is: " + format + " parameters are " + list);
                format = this.getReplacementFormat(format, list);
            }
            if ((formatter = config.getFormatter(format)) == null) {
                System.out.println("Message format invalid: " + format);
                MessageFormat fakeFormatter = config.getFormatter(this.getReplacementFormat(format, params == null ? Collections.EMPTY_LIST : Arrays.asList(params)));
                if (fakeFormatter == null) {
                    fakeFormatter = config.getFormatter(this.getReplacementFormat(params == null ? Collections.EMPTY_LIST : Arrays.asList(params)));
                }
                return fakeFormatter;
            }
            this.formatCache.put(format, formatter);
        }
        return formatter;
    }

    private String getReplacementFormat(String format, List<?> list) {
        StringBuilder buf = new StringBuilder(format.length() + 10);
        buf.append('\'').append(format).append("': ");
        for (int i = 0; i < list.size(); ++i) {
            buf.append('{').append(i).append("} ");
        }
        format = buf.toString();
        return format;
    }

    private String getReplacementFormat(List<?> list) {
        StringBuilder buf = new StringBuilder(19);
        buf.append(" format not ok  ");
        for (int i = 0; i < list.size(); ++i) {
            buf.append('{').append(i).append("} ");
        }
        return buf.toString();
    }

    public StringBuffer formatToChars(LogRecord record) {
        Object[] arguments = this.buildParameters(record);
        MessageFormat messageFormatter = this.getFormatter(record.getMessage(), record.getParameters());
        StringBuffer result = new StringBuffer(100);
        messageFormatter.format(record.getParameters(), result, (FieldPosition)null);
        List<CharSequence> messages = this.split(result);
        int count = messages.size();
        StringBuffer formatedLogRecord = new StringBuffer(100 * count);
        try {
            if (count == 1) {
                arguments[10] = messages.get(0);
                this.getRecordFormatter().format(arguments, formatedLogRecord, (FieldPosition)null);
            } else {
                for (int i = 0; i < count; ++i) {
                    String s = Integer.toString(i);
                    arguments[10] = this.getPad(s) + s + " " + messages.get(i);
                    this.getRecordFormatter().format(arguments, formatedLogRecord, (FieldPosition)null);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Logging error. Stack trace follows");
            e.printStackTrace();
            return new StringBuffer(Arrays.asList(arguments).toString() + '\n');
        }
        return formatedLogRecord;
    }

    private CharSequence getPad(String s) {
        return s.length() < 3 ? "000".subSequence(s.length(), 3) : s;
    }

    private Object[] buildParameters(LogRecord record) {
        Object[] arguments = new Object[12];
        arguments[0] = record.getSequenceNumber();
        arguments[1] = new Date(record.getMillis());
        arguments[2] = record.getLoggerName();
        arguments[3] = record.getSourceClassName();
        arguments[4] = record.getSourceMethodName();
        if (record instanceof RISLogRecord) {
            arguments[5] = ((RISLogRecord)record).getFilename();
            arguments[6] = ((RISLogRecord)record).getLineNumber();
        } else {
            arguments[5] = "";
            arguments[6] = MINUS_ONE;
        }
        arguments[7] = record.getThreadID();
        arguments[8] = record.getLevel().getName();
        arguments[9] = record.getLevel().intValue();
        arguments[11] = this.writeThrowable(arguments, record, 0);
        return arguments;
    }

    public CharSequence writeThrowable(LogRecord record) {
        return this.writeThrowable(nonParts, record, 0);
    }

    public CharSequence writeThrowable(Object[] otherParts, LogRecord record, int index) {
        Throwable t = record.getThrown();
        if (t == null) {
            return "";
        }
        assert (otherParts.length >= 11);
        StringBuffer tb = new StringBuffer(1000);
        while (t != null) {
            if (tb.length() > 200000) {
                tb.append("Stack trace too large to completely format\n");
                return tb;
            }
            Object[] throwParts = new Object[15];
            throwParts[11] = index++;
            throwParts[12] = t.getClass().getName();
            if (t.getMessage() == null) {
                throwParts[13] = "";
            } else {
                StringBuffer mb = new StringBuffer(1000);
                mb.append('\n');
                String[] messageLines = t.getMessage().split("\n");
                for (String line : messageLines) {
                    Object[] descriptionParts = new Object[13];
                    descriptionParts[11] = index++;
                    descriptionParts[12] = line;
                    System.arraycopy(otherParts, 0, descriptionParts, 0, 11);
                    this.getDescriptionFormatter().format(descriptionParts, mb, (FieldPosition)null);
                }
                throwParts[13] = mb;
            }
            StackTraceElement[] elements = t.getStackTrace();
            StringBuffer sb = new StringBuffer(1000);
            for (StackTraceElement element : elements) {
                Object[] stackParts = new Object[16];
                stackParts[11] = index++;
                stackParts[12] = element.getClassName();
                stackParts[13] = element.getMethodName();
                stackParts[14] = element.getFileName();
                stackParts[15] = element.getLineNumber();
                System.arraycopy(otherParts, 0, stackParts, 0, 11);
                this.getStackElementFormatter().format(stackParts, sb, (FieldPosition)null);
            }
            throwParts[14] = sb;
            System.arraycopy(otherParts, 0, throwParts, 0, 11);
            this.getExceptionFormatter().format(throwParts, tb, (FieldPosition)null);
            try {
                if (t instanceof SQLException) {
                    SQLException sqlt = (SQLException)t;
                    t = sqlt.getNextException();
                    continue;
                }
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                    continue;
                }
                if (t instanceof SAXException) {
                    t = ((SAXException)t).getException();
                    continue;
                }
                t = t.getCause();
            }
            catch (NoClassDefFoundError e) {
                System.out.println("cannot find class. backtrace will not be printed " + e);
                t = null;
            }
        }
        return tb;
    }

    public List<CharSequence> split(CharSequence input) {
        CharSequence match;
        int index = 0;
        ArrayList<CharSequence> matchList = null;
        Matcher m = this.lineBreak.matcher(input);
        while (m.find()) {
            if (m.start() - index < 0) continue;
            if (matchList == null) {
                matchList = new ArrayList<CharSequence>();
            }
            match = input.subSequence(index, m.start());
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return Collections.singletonList(input);
        }
        match = input.subSequence(index, input.length());
        matchList.add(match);
        return matchList;
    }

    static {
        MINUS_ONE = -1;
        config = new LogConfiguration(RISFormatter.class);
        nonParts = new Object[11];
        for (int i = 0; i < 11; ++i) {
            RISFormatter.nonParts[i] = "";
        }
    }
}

