/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public class RISLogRecord
extends LogRecord {
    protected String sourceClassName;
    protected String sourceMethodName;
    protected String filename;
    protected int lineNumber;
    protected boolean needToInferCaller = true;

    public RISLogRecord(Level level, String msg) {
        super(level, msg);
    }

    public String getFilename() {
        this.inferCaller();
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getLineNumber() {
        this.inferCaller();
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public String getSourceClassName() {
        this.inferCaller();
        return this.sourceClassName;
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    @Override
    public String getSourceMethodName() {
        this.inferCaller();
        return this.sourceMethodName;
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
    }

    protected void inferCaller() {
        if (!this.needToInferCaller) {
            return;
        }
        this.needToInferCaller = false;
        StackTraceElement frame = RISLogRecord.getCaller();
        if (frame != null) {
            this.setSourceClassName(frame.getClassName());
            this.setSourceMethodName(frame.getMethodName());
            this.setFilename(frame.getFileName());
            this.setLineNumber(frame.getLineNumber());
            return;
        }
    }

    protected static StackTraceElement getCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement frame = null;
        String cname = null;
        for (int ix = stack.length - 1; ix >= 0; --ix) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals("com.hds.commons.util.logging.RISLogger") && !cname.equals("java.util.logging.Logger") && !cname.equals("org.mortbay.log.Log")) continue;
            return stack[ix + 1];
        }
        return null;
    }
}

