/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.hds.commons.util.logging.LogManagerHelper;
import com.hds.commons.util.logging.RISLogRecord;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RISLogger
extends Logger {
    public static final int SUPPRESS_TRACE_SECS = LogManagerHelper.getIntProperty(RISLogger.class.getName() + ".suppressTraceSeconds", 30);
    private static final String LOG_SUPPRESS_FORMAT = "Log suppressed {0} times. {1}";
    private static final String TRACE_SUPPRESSED_MSG = "TRACE SUPPRESSED!";
    private static final long SUPPRESS_LOG_NANOS = TimeUnit.MILLISECONDS.toNanos(LogManagerHelper.getIntProperty(RISLogger.class.getName() + ".suppressExceptionLogMillis", 1000));
    private static final boolean TRACE_CACHE_ENABLED = LogManagerHelper.getBooleanProperty(RISLogger.class.getName() + ".traceSuppressionEnabled", true);
    private static final Cache<Integer, StackTraceTracker> stackTraceHashCache = TRACE_CACHE_ENABLED ? CacheBuilder.newBuilder().expireAfterWrite((long)SUPPRESS_TRACE_SECS, TimeUnit.SECONDS).maximumSize(1000L).removalListener((RemovalListener)new RemovalListener<Integer, StackTraceTracker>(){

        public void onRemoval(RemovalNotification<Integer, StackTraceTracker> notification) {
            ((StackTraceTracker)notification.getValue()).logDropped();
        }
    }).build() : null;
    private static final AtomicLong stackTraceId = TRACE_CACHE_ENABLED ? new AtomicLong() : null;
    private static ThreadLocal<MessageFormat> TRACE_SUPPRESSED_FORMAT = new ThreadLocal<MessageFormat>(){
        private final MessageFormat format = new MessageFormat("TRACE SUPPRESSED! Log suppressed {0} times. {1}");

        @Override
        protected MessageFormat initialValue() {
            return (MessageFormat)this.format.clone();
        }
    };
    private volatile Callable<StackTraceTracker> valueLoader;

    public RISLogger(String name) {
        super(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RISLogger getLogger() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            String className = new Exception().getStackTrace()[1].getClassName();
            // ** MonitorExit[var0] (shouldn't be in output)
            return (RISLogger)RISLogger.getLogger(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            LogManager manager = LogManager.getLogManager();
            Logger result = manager.getLogger(name);
            if (result == null) {
                result = new RISLogger(name);
                manager.addLogger(result);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return manager.getLogger(name);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean suppressExceptionIfNeeded(Throwable throwableObj) {
        StackTraceTracker tracker;
        Object[] traceArray = throwableObj.getStackTrace();
        int throwableObjHash = throwableObj.getClass().hashCode() * 31 + Arrays.hashCode(traceArray);
        try {
            tracker = (StackTraceTracker)stackTraceHashCache.get((Object)throwableObjHash, this.valueLoader());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        StackTraceTracker stackTraceTracker = tracker;
        synchronized (stackTraceTracker) {
            long lastLogged = tracker.lastLogged();
            long now = System.nanoTime();
            if (lastLogged < 0L && traceArray.length > 0) {
                traceArray[0] = new StackTraceElement(tracker.id() + ' ' + ((StackTraceElement)traceArray[0]).getClassName(), ((StackTraceElement)traceArray[0]).getMethodName(), ((StackTraceElement)traceArray[0]).getFileName(), ((StackTraceElement)traceArray[0]).getLineNumber());
                throwableObj.setStackTrace((StackTraceElement[])traceArray);
                tracker.lastLogged(now);
            } else {
                if (now - lastLogged < SUPPRESS_LOG_NANOS) {
                    tracker.incrementLogSuppressedCount();
                    return false;
                }
                throwableObj.setStackTrace(tracker.stackTrace());
                tracker.lastLogged(now);
            }
        }
        return true;
    }

    private void logIfNeeded(Throwable throwableObj, String message, Object[] params, String sourceClass, String sourceMethod, Level logLevel) {
        LogRecord lr = this.createLogRecord(logLevel, message);
        if (params != null) {
            lr.setParameters(params);
        }
        if (sourceClass != null) {
            lr.setSourceClassName(sourceClass);
        }
        if (sourceMethod != null) {
            lr.setSourceMethodName(sourceMethod);
        }
        if (throwableObj != null) {
            if (this.doWeNeedToLog(throwableObj, lr)) {
                this.doLog(lr);
            }
        } else {
            this.doLog(lr);
        }
    }

    private void logIfNeeded(Throwable throwableObj, String message, Object[] params, Level logLevel) {
        this.logIfNeeded(throwableObj, message, params, null, null, logLevel);
    }

    private boolean doWeNeedToLog(Throwable throwableObj, LogRecord logRecord) {
        boolean logTheMessage = true;
        if (TRACE_CACHE_ENABLED) {
            for (Throwable t = throwableObj; t != null; t = t.getCause()) {
                logTheMessage = this.suppressExceptionIfNeeded(t);
            }
        }
        if (logTheMessage) {
            logRecord.setThrown(throwableObj);
        }
        return logTheMessage;
    }

    @Override
    public void log(Level level, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(null, msg, null, level);
    }

    public LogRecord createLogRecord(Level level, String msg) {
        return new RISLogRecord(level, msg);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, boolean param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, boolean param1, boolean param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, boolean param1, long param2, long param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, boolean param1, Object param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, boolean param1, Object param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, boolean param2, double param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, long param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, byte param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, int param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, int param1, int param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, int param1, double param2, int param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, int param1, int param2, int param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, short param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, double param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, boolean param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, Object param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, long param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param1, Object param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable t, long param1, Object param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(t, msg, params, level);
    }

    public void log(Level level, String msg, long param1, Object param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, Object param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, Object param2, Object param3, Object param4, Object param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable t, long param1, Object param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(t, msg, params, level);
    }

    public void log(Level level, String msg, long param1, Object param2, long param3, long param4, Object param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, Object param2, long param3, long param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, Object param2, long param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, long param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, long param4, long param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, long param4, long param5, long param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param1, long param2, long param3, long param4, long param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param1, long param2, long param3, long param4, long param5, long param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, long param3, long param4, long param5, long param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param1, Object param2, long param3, long param4, long param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param2, long param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param2, param3};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, int param1, Object param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable cause, long param1, long param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(cause, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, long param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, long param3, long param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, long param3, long param4, Object param5, Object param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, long param3, String param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable t, long param1, long param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(t, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, long param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, float param1, float param2, float param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{Float.valueOf(param1), Float.valueOf(param2), Float.valueOf(param3)};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable throwable, long param1, long param2, long param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(throwable, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, long param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, long param3, Object param4, Object param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, long param3, long param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, long param3, long param4, Object param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, long param3, long param4, long param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, double param3, long param4, long param5, double param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, long param3, long param4, long param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, long param1, long param2, long param3, long param4, Object param5, Object param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, int param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param1, int param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, boolean param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, boolean param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, boolean param2, boolean param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, int param2, Object param3, int param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, int param2, int param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, long param4, long param5, Object param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, double param2) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param2, double param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param2, param3};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param2, param3, param4};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param2, Object param3, Object param4, boolean param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param2, param3, param4, param5};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, long param2, long param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, boolean param2, boolean param3, boolean param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, boolean param1, boolean param2, boolean param3, boolean param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4, Object param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, long param4, Object param5, Object param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, long param4, Object param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param1, Object param2, Object param3, Object param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param1, Object param2, Object param3, Object param4, Object param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable th, Object param1, Object param2, int param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(th, msg, params, level);
    }

    public void log(Level level, String msg, Throwable th, Object param1, Object param2, long param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(th, msg, params, level);
    }

    public void log(Level level, String msg, Throwable th, Object param1, long param2, Object param3) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3};
        this.logIfNeeded(th, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, int param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, long param3, int param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable param1, Object param2, long param3, int param4) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param2, param3, param4};
        this.logIfNeeded(param1, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, int param4, int param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, int param4, int param5, Object param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, int param2, Object param3, int param4, Object param5, boolean param6) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, int param2, Object param3, int param4, Object param5) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7, Object param8) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7, param8};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable t, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param2, param3, param4, param5, param6, param7};
        this.logIfNeeded(t, msg, params, level);
    }

    public void log(Level level, String msg, Throwable t, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7};
        this.logIfNeeded(t, msg, params, level);
    }

    public void log(Level level, String msg, Throwable t, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7, Object param8) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7, param8};
        this.logIfNeeded(t, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7, Object param8, Object param9) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7, param8, param9};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7, Object param8, Object param9, Object param10) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7, param8, param9, param10};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, int param2, Object param3, Object param4, int param5, Object param6, Object param7) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Object param1, Object param2, Object param3, Object param4, Object param5, Object param6, Object param7, Object param8, Object param9, Object param10, Object param11, Object param12) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1, param2, param3, param4, param5, param6, param7, param8, param9, param10, param11, param12};
        this.logIfNeeded(null, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, Object param) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param};
        this.logIfNeeded(thrown, msg, params, level);
    }

    public void log(Level level, String msg, Throwable thrown, boolean param) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param};
        this.logIfNeeded(thrown, msg, params, level);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(null, msg, params, level);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(thrown, msg, null, level);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(null, msg, null, sourceClass, sourceMethod, level);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logIfNeeded(null, msg, params, sourceClass, sourceMethod, level);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(null, msg, params, sourceClass, sourceMethod, level);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(thrown, msg, null, sourceClass, sourceMethod, level);
    }

    protected void doLog(LogRecord lr) {
        this.doLog(lr, null);
    }

    protected void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.getName());
        try {
            this.log(lr);
        }
        catch (RuntimeException e) {
            System.err.println("Attempt to log message failed: level=" + lr.getLevel() + "; msg=" + lr.getMessage() + " parameters:" + Arrays.toString(lr.getParameters()));
        }
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord lr = this.createLogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr, bundleName);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord lr = this.createLogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord lr = this.createLogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.logIfNeeded(thrown, msg, null, sourceClass, sourceMethod, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callable<StackTraceTracker> valueLoader() {
        if (this.valueLoader == null) {
            RISLogger rISLogger = this;
            synchronized (rISLogger) {
                if (this.valueLoader == null) {
                    this.valueLoader = new Callable<StackTraceTracker>(){

                        @Override
                        public StackTraceTracker call() throws Exception {
                            return new StackTraceTracker(RISLogger.this);
                        }
                    };
                }
            }
        }
        return this.valueLoader;
    }

    static /* synthetic */ AtomicLong access$000() {
        return stackTraceId;
    }

    private static class StackTraceTracker {
        private final RISLogger logger;
        private long lastLogged = 0L;
        private int logSuppressedCount = 0;
        private final String id = String.format("TRACE ID %016x", RISLogger.access$000().getAndIncrement());

        public StackTraceTracker(RISLogger logger) {
            this.logger = logger;
            this.lastLogged = -1L;
        }

        public synchronized void lastLogged(long updatedValue) {
            this.lastLogged = updatedValue;
        }

        public synchronized long lastLogged() {
            return this.lastLogged;
        }

        public String id() {
            return this.id;
        }

        public synchronized void incrementLogSuppressedCount() {
            ++this.logSuppressedCount;
        }

        public synchronized void logDropped() {
            if (this.logSuppressedCount > 0) {
                this.logger.log(Level.WARNING, RISLogger.LOG_SUPPRESS_FORMAT, (long)this.logSuppressedCount, (Object)this.id);
                this.logSuppressedCount = 0;
            }
        }

        public synchronized StackTraceElement[] stackTrace() {
            int logSuppressedCount = this.logSuppressedCount;
            this.logSuppressedCount = 0;
            return new StackTraceElement[]{new StackTraceElement("", ((MessageFormat)TRACE_SUPPRESSED_FORMAT.get()).format(new Object[]{logSuppressedCount, this.id}), null, 0)};
        }
    }
}

