/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util.logging;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hds.commons.exception.Exceptions;
import com.hds.commons.util.logging.LogManagerHelper;
import com.hds.commons.util.logging.RISLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class RateLimiterFilter
implements Filter {
    private static RISLogger log;
    private static final String PROPERTY_BASE;
    private static final String LIMIT_PROPERTY_NAME;
    private static final String RECALCULATE_PROPERTY_NAME;
    private static final String MAX_LIMIT_LEVEL;
    private static final String MAX_LOGS_TRACKED;
    private static final String SUMMARY_LOG_DELAY;
    private static final AtomicInteger droppedMessages;
    private static final long SUMMARY_LOG_DELAY_NANOS;
    private static final long RECALCULATE_AFTER_NANOS;
    private static volatile long lastLog;
    private final int speedLimit;
    private final int maxLevelToLimit;
    private final long recalculateAfterNanos;
    private final Callable<Governor> governorCreator = new Callable<Governor>(){

        @Override
        public Governor call() throws Exception {
            return new Governor();
        }
    };
    private static final Cache<String, Governor> cache;

    @VisibleForTesting
    static void invalidateCache() {
        cache.invalidateAll();
    }

    private static void logSummary(long now) {
        long origLastLog = lastLog;
        if (SUMMARY_LOG_DELAY_NANOS > 0L && now - origLastLog > SUMMARY_LOG_DELAY_NANOS) {
            lastLog = now;
            int dropped = droppedMessages.getAndSet(0);
            if (dropped > 0) {
                log.log(Level.WARNING, "{0} messages dropped by rate limiter over the past {1}s", new Object[]{dropped, TimeUnit.NANOSECONDS.toSeconds(now - origLastLog)});
            }
        }
    }

    public RateLimiterFilter() {
        this(LogManagerHelper.getIntProperty(LIMIT_PROPERTY_NAME, -1), LogManagerHelper.getLevelProperty(MAX_LIMIT_LEVEL, Level.INFO), null);
    }

    public RateLimiterFilter(String speedLimit) {
        this(Integer.parseInt(speedLimit), Level.INFO, null);
    }

    public RateLimiterFilter(String speedLimit, String level) {
        this(Integer.parseInt(speedLimit), Level.parse(level), null);
    }

    @VisibleForTesting
    RateLimiterFilter(int speedLimit, Level level, Long recalculateAfterNanos) {
        if (log == null) {
            log = RISLogger.getLogger();
        }
        level = level == null ? Level.INFO : level;
        this.speedLimit = speedLimit;
        this.maxLevelToLimit = level.intValue();
        this.recalculateAfterNanos = recalculateAfterNanos == null ? RECALCULATE_AFTER_NANOS : recalculateAfterNanos;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        try {
            return this.shouldLimit(record) ? ((Governor)cache.get((Object)record.getMessage(), this.governorCreator)).shouldLog() : true;
        }
        catch (ExecutionException e) {
            Exceptions.unwrapUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    private boolean shouldLimit(LogRecord record) {
        return this.speedLimit > 0 && record.getLevel().intValue() <= this.maxLevelToLimit && record.getMessage() != null;
    }

    static {
        PROPERTY_BASE = RateLimiterFilter.class.getName() + ".";
        LIMIT_PROPERTY_NAME = PROPERTY_BASE + "limitPerSecond";
        RECALCULATE_PROPERTY_NAME = PROPERTY_BASE + ".recalculateSecs";
        MAX_LIMIT_LEVEL = PROPERTY_BASE + "maxLimitLevel";
        MAX_LOGS_TRACKED = PROPERTY_BASE + "maxMessagesTracked";
        SUMMARY_LOG_DELAY = PROPERTY_BASE + "summaryLogSeconds";
        droppedMessages = new AtomicInteger();
        lastLog = System.nanoTime();
        long recalculateAfterSecs = LogManagerHelper.getLongProperty(RECALCULATE_PROPERTY_NAME, 60);
        Preconditions.checkArgument((recalculateAfterSecs > 0L ? 1 : 0) != 0);
        RECALCULATE_AFTER_NANOS = TimeUnit.SECONDS.toNanos(recalculateAfterSecs);
        SUMMARY_LOG_DELAY_NANOS = TimeUnit.SECONDS.toNanos(LogManagerHelper.getLongProperty(SUMMARY_LOG_DELAY, -1));
        cache = CacheBuilder.newBuilder().expireAfterAccess(RECALCULATE_AFTER_NANOS, TimeUnit.NANOSECONDS).maximumSize((long)LogManagerHelper.getIntProperty(MAX_LOGS_TRACKED, 1000)).build();
    }

    private class Governor
    extends AtomicInteger {
        private volatile long time = System.nanoTime();

        private Governor() {
        }

        public boolean shouldLog() {
            long speed = this.speed();
            if (speed > (long)RateLimiterFilter.this.speedLimit) {
                droppedMessages.getAndIncrement();
                return false;
            }
            this.getAndIncrement();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long speed() {
            int count;
            long now = System.nanoTime();
            long elapsed = now - this.time;
            if (elapsed > RateLimiterFilter.this.recalculateAfterNanos) {
                Governor governor = this;
                synchronized (governor) {
                    elapsed = now - this.time;
                    if (elapsed > RateLimiterFilter.this.recalculateAfterNanos) {
                        int expect;
                        long originalElapsed = elapsed;
                        elapsed = RateLimiterFilter.this.recalculateAfterNanos >> 1;
                        while (!this.compareAndSet(expect = this.get(), count = (int)((long)expect * elapsed / originalElapsed))) {
                        }
                        this.time = now - elapsed;
                    } else {
                        count = this.get();
                    }
                }
            } else {
                count = this.get();
            }
            RateLimiterFilter.logSummary(now);
            long elapsedSecs = TimeUnit.NANOSECONDS.toSeconds(elapsed);
            return elapsedSecs == 0L ? (long)count : (long)count / (elapsedSecs + 1L);
        }
    }
}

