/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.version;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

public class EnumTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
            return null;
        }
        if (!rawType.isEnum()) {
            rawType = rawType.getSuperclass();
        }
        return new EnumTypeAdapter(rawType);
    }

    private static <T extends Enum<T>> BiMap<T, String> getValueMappings(Class<T> classOfT) {
        EnumMap valueMapping = Maps.newEnumMap(classOfT);
        for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
            try {
                SerializedName serializedName = classOfT.getField(constant.name()).getAnnotation(SerializedName.class);
                valueMapping.put(constant, serializedName != null ? serializedName.value() : constant.name());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return EnumHashBiMap.create((Map)valueMapping);
    }

    public class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        Class<T> classOfT;
        BiMap<T, String> valueMappings;

        public EnumTypeAdapter(Class<T> classOfT) {
            this.classOfT = classOfT;
            this.valueMappings = EnumTypeAdapterFactory.getValueMappings(classOfT);
        }

        public void write(JsonWriter out, T value) throws IOException {
            out.value(value == null ? null : (String)this.valueMappings.get(value));
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String value = in.nextString();
            if (!this.valueMappings.containsValue((Object)value)) {
                throw new JsonSyntaxException(String.format("No enum constant for value '%s' in %s", value, this.classOfT.getCanonicalName()));
            }
            return (T)((Enum)this.valueMappings.inverse().get((Object)value));
        }
    }
}

