/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.version;

import com.hds.commons.collections.Pair;
import com.hds.commons.exception.InvalidInputException;
import com.hds.commons.version.StoredJsonParser;
import com.hds.commons.version.UnsupportedVersionException;
import com.hds.commons.version.VersionKey;
import com.hds.commons.version.VersionParser;
import java.lang.reflect.Type;

public abstract class StoredVersion<V extends VersionKey<V>, T> {
    public final V version;
    public final T object;

    public StoredVersion(V version, T object) {
        this.version = version;
        this.object = object;
    }

    public static <V extends VersionKey<V>> String versionPrefix(V version) {
        return version.getVersionString() + " ";
    }

    public abstract String toString();

    public String toString(StoredJsonParser<V> parser) {
        return StoredVersion.versionPrefix(this.version) + parser.toJson(this.version, this.object);
    }

    protected static <V, T> Pair<V, T> parse(String storedVersion, VersionParser<V> versionParser, StoredJsonParser<V> jsonParser, Class<T> classOfT) throws UnsupportedVersionException, InvalidInputException {
        String[] values = StoredVersion.split(storedVersion);
        V version = versionParser.parse(values[0]);
        return Pair.create(version, jsonParser.parse(version, values[1], classOfT));
    }

    protected static <V, T> Pair<V, T> parse(String storedVersion, VersionParser<V> versionParser, StoredJsonParser<V> jsonParser, Type typeOfClass) throws UnsupportedVersionException, InvalidInputException {
        String[] values = StoredVersion.split(storedVersion);
        V version = versionParser.parse(values[0]);
        Object obj = jsonParser.parse(version, values[1], typeOfClass);
        return Pair.create(version, obj);
    }

    private static String[] split(String raw) throws InvalidInputException {
        String[] values = raw.split(" ", 2);
        if (values.length != 2) {
            throw new InvalidInputException("Input " + raw + " did not have correct format");
        }
        return values;
    }
}

