/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.version;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.hds.commons.version.VersionKey;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version>,
VersionKey<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\d+\\.)+\\d+)");
    private final Integer[] version;

    public static Version create(String version) {
        return version == null ? null : new Version(version);
    }

    public static Version create(Integer ... pieces) {
        return pieces == null ? null : new Version(pieces);
    }

    public static Version find(CharSequence input) {
        Matcher matcher;
        if (input != null && (matcher = VERSION_PATTERN.matcher(input)).find()) {
            String version = matcher.group(1);
            return Version.create(version);
        }
        return null;
    }

    private Version(String versionStr) {
        String[] pieces = versionStr.split("\\.");
        this.version = new Integer[pieces.length];
        for (int i = 0; i < pieces.length; ++i) {
            this.version[i] = Integer.valueOf(pieces[i]);
        }
    }

    private Version(Integer[] pieces) {
        this.version = Arrays.copyOf(pieces, pieces.length);
    }

    public int getMajor() throws ArrayIndexOutOfBoundsException {
        return this.version[0];
    }

    public int getMinor() throws ArrayIndexOutOfBoundsException {
        return this.version[1];
    }

    public String getMajorMinor() throws ArrayIndexOutOfBoundsException {
        return String.format("%d.%d", this.getMajor(), this.getMinor());
    }

    public boolean sameMajorMinor(Version other) throws ArrayIndexOutOfBoundsException {
        return this.getMajor() == other.getMajor() && this.getMinor() == other.getMinor();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Version) {
            return Arrays.equals((Object[])this.version, (Object[])((Version)obj).version);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version});
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            return 1;
        }
        int smallest = Math.min(this.version.length, o.version.length);
        for (int i = 0; i < smallest; ++i) {
            if (this.version[i].equals(o.version[i])) continue;
            return this.version[i].compareTo(o.version[i]);
        }
        return this.version.length - o.version.length;
    }

    public String toString() {
        return Joiner.on((char)'.').join((Object[])this.version);
    }

    @Override
    public String getVersionString() {
        return this.toString();
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Version version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public boolean isGreaterThan(Version version) {
        return !this.isLessThanOrEqualTo(version);
    }

    @Override
    public boolean isLessThanOrEqualTo(Version version) {
        return this.compareTo(version) <= 0;
    }

    @Override
    public boolean isLessThan(Version version) {
        return !this.isGreaterThanOrEqualTo(version);
    }
}

