/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.version;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.hds.commons.exception.Exceptions;
import com.hds.commons.json.SubClassTypeAdapterFactory;
import com.hds.commons.version.EnumTypeAdapterFactory;
import com.hds.commons.version.UnsupportedVersionException;
import com.hds.commons.version.VersionKey;
import com.hds.commons.version.VersionedGsonTypeAdapterFactoryBuilder;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;

public class VersionedGsonHelper<V extends Enum<V>> {
    private final V latestApiVersion;
    private final Map<V, Gson> apiVersionToGsonMap;

    public VersionedGsonHelper(VersionedGsonTypeAdapterFactoryBuilder<V> factoryBuilder, Class<V> clazz) {
        this(factoryBuilder, clazz, false);
    }

    public VersionedGsonHelper(VersionedGsonTypeAdapterFactoryBuilder<V> factoryBuilder, Class<V> clazz, boolean prettyPrint) {
        this.apiVersionToGsonMap = new EnumMap<Gson, Gson>(clazz);
        Enum latestApiVersion = null;
        for (Enum apiVersion : (Enum[])clazz.getEnumConstants()) {
            if (latestApiVersion == null) {
                latestApiVersion = apiVersion;
            } else if (((VersionKey)((Object)apiVersion)).isGreaterThanOrEqualTo(latestApiVersion)) {
                latestApiVersion = apiVersion;
            }
            GsonBuilder gb = new GsonBuilder();
            if (prettyPrint) {
                gb.setPrettyPrinting();
            }
            gb.registerTypeAdapterFactory(factoryBuilder.build(apiVersion));
            gb.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
            gb.registerTypeAdapterFactory((TypeAdapterFactory)new SubClassTypeAdapterFactory());
            Gson gson = gb.create();
            this.apiVersionToGsonMap.put((Gson)apiVersion, gson);
        }
        this.latestApiVersion = latestApiVersion;
    }

    public V getLatestVersion() {
        return this.latestApiVersion;
    }

    public <T> T fromJson(V apiVersion, String json, Class<T> classOfT) throws UnsupportedVersionException {
        try {
            return (T)this.getGson(apiVersion).fromJson(json, classOfT);
        }
        catch (JsonParseException e) {
            this.throwUnsupportedCause(e);
            throw e;
        }
    }

    public <T> T fromJson(V apiVersion, String json, Type typeOfClass) throws UnsupportedVersionException {
        try {
            return (T)this.getGson(apiVersion).fromJson(json, typeOfClass);
        }
        catch (JsonParseException e) {
            this.throwUnsupportedCause(e);
            throw e;
        }
    }

    public <T> T fromJson(V apiVersion, Reader json, Class<T> classOfT) throws UnsupportedVersionException {
        try {
            return (T)this.getGson(apiVersion).fromJson(json, classOfT);
        }
        catch (JsonParseException e) {
            this.throwUnsupportedCause(e);
            throw e;
        }
    }

    public Gson getGson(V apiVersion) {
        Preconditions.checkNotNull(apiVersion);
        Gson gson = this.apiVersionToGsonMap.get(apiVersion);
        return gson;
    }

    private void throwUnsupportedCause(JsonParseException e) throws UnsupportedVersionException {
        Exceptions.unwrapDeep(e, UnsupportedVersionException.class);
    }
}

