/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.version;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.hds.commons.exception.Exceptions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class VersionedGsonTypeAdapterFactory<K extends Enum<K>>
implements TypeAdapterFactory {
    private final Class<K> versionClazz;
    private final K apiVersion;

    protected VersionedGsonTypeAdapterFactory(K apiVersion, Class<K> clazz) {
        this.versionClazz = clazz;
        this.apiVersion = apiVersion;
    }

    protected abstract String getClassMethodName();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class clazz = type.getRawType();
        try {
            Method method = clazz.getMethod(this.getClassMethodName(), this.versionClazz);
            if (method != null) {
                return new VersionedJsonTypeAdapter(this, gson, this.apiVersion, clazz, method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private void handleCheckedException(Exception e) throws IOException {
        Exceptions.unwrapUnchecked(e);
        Exceptions.unwrap(e, IOException.class);
        throw new IOException(e);
    }

    protected static class VersionedJsonTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Gson gson;
        private final K apiVersion;
        private final Class<T> clazz;
        private final Method method;
        final /* synthetic */ VersionedGsonTypeAdapterFactory this$0;

        public VersionedJsonTypeAdapter(Gson gson, K apiVersion, Class<T> clazz, Method method) {
            this.this$0 = this$0;
            this.gson = gson;
            this.apiVersion = apiVersion;
            this.clazz = clazz;
            this.method = method;
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.getAdapter(this.clazz).write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            Class c = this.clazz;
            try {
                c = (Class)this.method.invoke(null, this.apiVersion);
            }
            catch (IllegalAccessException e) {
                this.this$0.handleCheckedException(e);
            }
            catch (InvocationTargetException e) {
                this.this$0.handleCheckedException(e);
            }
            return (T)this.getAdapter(c).read(in);
        }

        private TypeAdapter<T> getAdapter(Class<?> clazz) {
            return this.gson.getDelegateAdapter((TypeAdapterFactory)this.this$0, TypeToken.get(clazz));
        }
    }
}

