/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.hds.hcpaw.fss.api.AnywhereActivityAPI;
import com.hds.hcpaw.fss.api.AnywhereClientAPI;
import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.AnywhereFileAPI;
import com.hds.hcpaw.fss.api.AnywhereFolderAPI;
import com.hds.hcpaw.fss.api.AnywhereLinkAPI;
import com.hds.hcpaw.fss.api.AnywherePathAPI;
import com.hds.hcpaw.fss.api.AnywhereProviderAPI;
import com.hds.hcpaw.fss.api.AnywhereSamlAPI;
import com.hds.hcpaw.fss.api.AnywhereShareAPI;
import com.hds.hcpaw.fss.api.AnywhereUserAPI;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AnywhereHttpException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.Authentication;
import java.io.IOException;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class AnywhereAPI {
    private static final String AUTH_PATH = "/fss/public/login/oauth";
    private static final String AUTH_CERTIFICATE_PATH = "/fss/public/certificate";
    private static final String GRANT_TYPE = "urn:hds:oauth:negotiate-client";
    private final AnywhereConnector connector;
    private final AnywhereFolderAPI folderApi;
    private final AnywhereFileAPI fileApi;
    private final AnywherePathAPI pathApi;
    private final AnywhereLinkAPI linkApi;
    private final AnywhereUserAPI userApi;
    private final AnywhereProviderAPI providerApi;
    private final AnywhereShareAPI shareApi;
    private final AnywhereClientAPI clientApi;
    private final AnywhereActivityAPI activityApi;
    private final AnywhereSamlAPI samlApi;

    private AnywhereAPI(AnywhereConnector connector) {
        this.connector = connector;
        this.folderApi = new AnywhereFolderAPI(connector);
        this.fileApi = new AnywhereFileAPI(connector);
        this.pathApi = new AnywherePathAPI(connector);
        this.linkApi = new AnywhereLinkAPI(connector);
        this.userApi = new AnywhereUserAPI(connector);
        this.providerApi = new AnywhereProviderAPI(connector);
        this.shareApi = new AnywhereShareAPI(connector);
        this.clientApi = new AnywhereClientAPI(connector);
        this.activityApi = new AnywhereActivityAPI(connector);
        this.samlApi = new AnywhereSamlAPI(connector);
    }

    public AuthToken authenticate(String username, String password) throws IOException, AnywhereException {
        return ApiVersionedAction.run(this.connector, apiVersion -> {
            Authentication body = Authentication.create(apiVersion, username, password, GRANT_TYPE);
            return this.connector.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, null, AUTH_PATH, null, body, AuthToken.class);
        });
    }

    public AuthToken authenticateCertificate() throws IOException, AnywhereException {
        return ApiVersionedAction.run(this.connector, apiVersion -> {
            Authentication body = Authentication.create(apiVersion, "", "", GRANT_TYPE);
            return this.connector.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, null, AUTH_CERTIFICATE_PATH, null, body, AuthToken.class);
        });
    }

    public boolean status() {
        try {
            this.connector.invokeNoBody(AnywhereConnector.RequestMethod.POST, this.connector.getLatestCommonApiVersion(), null, AUTH_PATH, null, Void.class);
            return true;
        }
        catch (AnywhereHttpException e) {
            return e.getSupportedVersions() != null;
        }
        catch (AnywhereException | IOException e) {
            return false;
        }
    }

    public AnywhereFolderAPI getFolderAPI() {
        return this.folderApi;
    }

    public AnywhereFileAPI getFileAPI() {
        return this.fileApi;
    }

    public AnywherePathAPI getPathAPI() {
        return this.pathApi;
    }

    public AnywhereLinkAPI getLinkAPI() {
        return this.linkApi;
    }

    public AnywhereUserAPI getUserAPI() {
        return this.userApi;
    }

    public AnywhereProviderAPI getProviderAPI() {
        return this.providerApi;
    }

    public AnywhereShareAPI getShareAPI() {
        return this.shareApi;
    }

    public AnywhereClientAPI getClientAPI() {
        return this.clientApi;
    }

    public AnywhereActivityAPI getActivityAPI() {
        return this.activityApi;
    }

    public AnywhereSamlAPI getSamlAPI() {
        return this.samlApi;
    }

    public static class Builder {
        private final AnywhereConnector.Builder connectorBuilder;

        public Builder(String serverUrl) throws AnywhereException {
            this.connectorBuilder = new AnywhereConnector.Builder(serverUrl);
        }

        public AnywhereAPI build() {
            return new AnywhereAPI(this.connectorBuilder.build());
        }

        public Builder server(String server) throws AnywhereException {
            this.connectorBuilder.server(server);
            return this;
        }

        public Builder maxIdleConnections(int maxIdleConnections) {
            this.connectorBuilder.maxIdleConnections(maxIdleConnections);
            return this;
        }

        public Builder keepAliveDuration(long keepAliveDuration, TimeUnit timeUnit) {
            this.connectorBuilder.keepAliveDuration(keepAliveDuration, timeUnit);
            return this;
        }

        public Builder useKeyStore(KeyStore keyStore) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
            this.connectorBuilder.useKeyStore(keyStore);
            return this;
        }

        public Builder useCertificateChain(X509Certificate[] certChain) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
            this.connectorBuilder.useCertificateChain(certChain);
            return this;
        }

        public Builder insecureSSL() throws KeyManagementException, NoSuchAlgorithmException {
            this.connectorBuilder.insecureSSL();
            return this;
        }

        public Builder useSSLContext(SSLContext sslContext) throws KeyManagementException, NoSuchAlgorithmException {
            this.connectorBuilder.useSSLContext(sslContext);
            return this;
        }

        public Builder skipHostnameVerification() {
            this.connectorBuilder.skipHostnameVerification();
            return this;
        }

        public Builder readTimeoutDuration(long readTimeoutDuration, TimeUnit timeUnit) {
            this.connectorBuilder.readTimeoutDuration(readTimeoutDuration, timeUnit);
            return this;
        }

        public Builder writeTimeoutDuration(long writeTimeoutDuration, TimeUnit timeUnit) {
            this.connectorBuilder.writeTimeoutDuration(writeTimeoutDuration, timeUnit);
            return this;
        }

        public Builder proxy(String hostname, int port) {
            this.connectorBuilder.proxy(hostname, port);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.connectorBuilder.proxy(proxy);
            return this;
        }
    }
}

