/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.ClearClientCredentialsRequest;
import com.hds.hcpaw.fss.api.model.Client;
import com.hds.hcpaw.fss.api.model.ClientDeregisterRequest;
import com.hds.hcpaw.fss.api.model.ClientListing;
import com.hds.hcpaw.fss.api.model.ClientRenameRequest;
import java.io.IOException;

public class AnywhereClientAPI {
    private static final String CLIENT_URI = "/fss/public/client";
    private AnywhereConnector conn;

    protected AnywhereClientAPI(AnywhereConnector connector) {
        this.conn = connector;
    }

    public Client rename(AuthToken authToken, String id, String name) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ClientRenameRequest body = ClientRenameRequest.create(apiVersion, id, name);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/client/rename", null, body, Client.class);
        });
    }

    public Client deregister(AuthToken authToken, String id, boolean wipe) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ClientDeregisterRequest body = ClientDeregisterRequest.create(apiVersion, id, wipe);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/client/deregister", null, body, Client.class);
        });
    }

    public ClientListing list(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> this.conn.invokeNoBody(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/client/list", null, ClientListing.class));
    }

    public Client clearCredentials(AuthToken authToken, String id) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ClearClientCredentialsRequest body = ClearClientCredentialsRequest.create(apiVersion, id);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/client/clearCredentials", null, body, Client.class);
        });
    }
}

