/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.hds.commons.exception.InvalidInputException;
import com.hds.commons.strings.Splitters;
import com.hds.hcpaw.fss.api.conn.DelegatingSSLSocketFactory;
import com.hds.hcpaw.fss.api.conn.DelegatingTrustManager;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AnywhereExceptionFactory;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ErrorMessage;
import com.hds.hcpaw.fss.api.model.InputStreamResult;
import com.hds.hcpaw.fss.api.version.FssApiGsonHelper;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class AnywhereConnector {
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final MediaType MEDIA_TYPE_APPLICATION_OCTETSTREAM = MediaType.parse((String)"application/octet-stream");
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_FORM_ENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");
    private static final int SC_NO_CONTENT = 204;
    private static final String UTF_8 = BaseFssApiResource.UTF_8.toString();
    private final HttpUrl serverUrl;
    private FssApiVersion latestCommonVersion;
    private final OkHttpClient client;

    private AnywhereConnector(HttpUrl serverUrl, OkHttpClient client) {
        this.serverUrl = serverUrl;
        this.client = client;
        this.latestCommonVersion = FssApiVersion.getLatest();
    }

    protected FssApiVersion getLatestCommonApiVersion() {
        return this.latestCommonVersion;
    }

    protected <T> T invokeWithFormData(RequestMethod method, FssApiVersion apiVersion, String username, String password, String path, Map<String, String> parameters, String content, Class<T> responseType) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, AnywhereConnector.basicAuthHeader(username, password), path, parameters, null, RequestBody.create((MediaType)MEDIA_TYPE_FORM_ENCODED, (String)content), responseType);
    }

    protected <T> T invokeWithStream(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, String ifMatch, InputStream content, Class<T> responseType) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, auth.toString(), path, parameters, ifMatch, AnywhereConnector.getStreamingRequestBody(content), responseType);
    }

    protected <T> T invokeWithStream(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, InputStream content, OutputStream outputStream, Class<T> responseType, String responseHeaderKey) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, auth.toString(), path, parameters, null, AnywhereConnector.getStreamingRequestBody(content), outputStream, responseType, responseHeaderKey);
    }

    protected <U, T> T invokeWithObject(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, U body, Class<T> responseType) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, auth == null ? null : auth.toString(), path, parameters, null, RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)FssApiGsonHelper.toJson(body)), responseType);
    }

    protected <U> void invokeWithObject(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, U body) throws IOException, AnywhereException {
        this.runRequest(method, apiVersion, auth.toString(), path, parameters, null, RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)FssApiGsonHelper.toJson(body)));
    }

    protected <U, T> T invokeWithObject(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, U body, OutputStream outputStream, Class<T> responseType, String responseHeaderKey) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, auth.toString(), path, parameters, null, RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)FssApiGsonHelper.toJson(body)), outputStream, responseType, responseHeaderKey);
    }

    protected <U, T> InputStreamResult<T> invokeWithObject(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, U body, Class<T> responseType, String responseHeaderKey) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, auth.toString(), path, parameters, null, RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)FssApiGsonHelper.toJson(body)), responseType, responseHeaderKey);
    }

    protected <T> T invokeNoBody(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, OutputStream outputStream, Class<T> responseType, String responseHeaderKey) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, auth.toString(), path, parameters, null, null, outputStream, responseType, responseHeaderKey);
    }

    protected <T> T invokeNoBody(RequestMethod method, FssApiVersion apiVersion, AuthToken auth, String path, Map<String, String> parameters, Class<T> responseType) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, auth == null ? null : auth.toString(), path, parameters, null, RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)""), responseType);
    }

    private <T> T runRequest(RequestMethod method, final FssApiVersion apiVersion, String authHeader, String path, Map<String, String> parameters, String ifMatch, RequestBody body, final Class<T> responseType) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, authHeader, path, parameters, ifMatch, body, new SuccessfulResponseHandler<T>(){

            @Override
            public T handleResponse(Response response) throws IOException, AnywhereException {
                try {
                    return FssApiGsonHelper.fromJson(apiVersion, response.body().string(), responseType);
                }
                catch (InvalidInputException e) {
                    throw new AnywhereException("Could not deserialize body", e);
                }
            }
        });
    }

    private void runRequest(RequestMethod method, FssApiVersion apiVersion, String authHeader, String path, Map<String, String> parameters, String ifMatch, RequestBody body) throws IOException, AnywhereException {
        this.runRequest(method, apiVersion, authHeader, path, parameters, ifMatch, body, (SuccessfulResponseHandler)null);
    }

    private <T> T runRequest(RequestMethod method, final FssApiVersion apiVersion, String authHeader, String path, Map<String, String> parameters, String ifMatch, RequestBody body, final OutputStream output, final Class<T> responseType, final String responseHeaderKey) throws IOException, AnywhereException {
        return this.runRequest(method, apiVersion, authHeader, path, parameters, ifMatch, body, new SuccessfulResponseHandler<T>(){

            @Override
            public T handleResponse(Response response) throws IOException, AnywhereException {
                Object result;
                if (response.code() == 204) {
                    return null;
                }
                try {
                    result = FssApiGsonHelper.fromJson(apiVersion, response.header(responseHeaderKey), responseType);
                }
                catch (InvalidInputException e) {
                    throw new AnywhereException("Could not deserialize json response header", e);
                }
                try (Sink sink = Okio.sink((OutputStream)output);
                     Source source = Okio.source((InputStream)response.body().byteStream());
                     BufferedSink bufSink = Okio.buffer((Sink)sink);){
                    bufSink.writeAll(source);
                }
                return result;
            }
        });
    }

    private <T> InputStreamResult<T> runRequest(RequestMethod method, final FssApiVersion apiVersion, String authHeader, String path, Map<String, String> parameters, String ifMatch, RequestBody body, final Class<T> responseType, final String responseHeaderKey) throws IOException, AnywhereException {
        return (InputStreamResult)this.runRequest(method, apiVersion, authHeader, path, parameters, ifMatch, body, new SuccessfulResponseHandler<InputStreamResult<T>>(){

            @Override
            public InputStreamResult<T> handleResponse(Response response) throws IOException, AnywhereException {
                Object headerObject;
                if (response.code() == 204) {
                    return null;
                }
                try {
                    headerObject = FssApiGsonHelper.fromJson(apiVersion, response.header(responseHeaderKey), responseType);
                }
                catch (InvalidInputException e) {
                    throw new AnywhereException("Could not deserialize json response header", e);
                }
                return new InputStreamResult(headerObject, response.body().byteStream());
            }
        });
    }

    private <T> T runRequest(RequestMethod method, FssApiVersion apiVersion, String authHeader, String path, Map<String, String> parameters, String ifMatch, RequestBody body, SuccessfulResponseHandler<T> responseHandler) throws IOException, AnywhereException {
        Request request = this.generateRequest(method, apiVersion, authHeader, path, parameters, ifMatch, body);
        Response response = this.client.newCall(request).execute();
        this.updateFssApiVersion(response, apiVersion);
        if (!response.isSuccessful()) {
            ErrorMessage errorMessage = null;
            if (response.body().contentLength() > 0L || response.headers("Transfer-Encoding").contains("chunked")) {
                try {
                    errorMessage = FssApiGsonHelper.fromJson(apiVersion, response.body().string(), ErrorMessage.class);
                }
                catch (JsonSyntaxException | InvalidInputException throwable) {
                    // empty catch block
                }
            }
            Set<FssApiVersion> supportedVersions = this.getSupportedVersions(response);
            AnywhereExceptionFactory.throwHttpException(response.message(), response.code(), errorMessage, supportedVersions);
        }
        T result = null;
        if (responseHandler != null) {
            result = responseHandler.handleResponse(response);
        }
        return result;
    }

    private void updateFssApiVersion(Response response, FssApiVersion apiVersionUsed) throws AwUnsupportedApiVersionException {
        Set<FssApiVersion> supportedVersions = this.getSupportedVersions(response);
        if (!(supportedVersions == null || supportedVersions.isEmpty() || supportedVersions.contains(apiVersionUsed) && this.latestCommonVersion == FssApiVersion.getLatest())) {
            Set serverVersions;
            Set<FssApiVersion> clientVersions = FssApiVersion.getSupportedVersionSet(FssApiVersion.getOldest(), FssApiVersion.getLatest());
            Sets.SetView commonVersions = Sets.intersection(clientVersions, serverVersions = supportedVersions.stream().filter(p -> p != FssApiVersion.UNSET).collect(Collectors.toSet()));
            TreeSet sortedCommon = Sets.newTreeSet((Iterable)commonVersions);
            if (!sortedCommon.isEmpty() && this.latestCommonVersion != sortedCommon.last()) {
                this.latestCommonVersion = (FssApiVersion)sortedCommon.last();
            }
            if (!serverVersions.contains(apiVersionUsed)) {
                throw new AwUnsupportedApiVersionException(apiVersionUsed);
            }
        }
    }

    private Set<FssApiVersion> getSupportedVersions(Response response) {
        String serverVersionsStr = response.header("X-HCPAW-SUPPORTED-FSS-API-VERSIONS");
        Set<FssApiVersion> supportedVersions = null;
        if (serverVersionsStr != null) {
            HashSet serverVersionStrs = Sets.newHashSet((Iterable)Splitters.comma().split((CharSequence)serverVersionsStr));
            supportedVersions = FssApiVersion.getValuesFromStringSet(serverVersionStrs);
        }
        return supportedVersions;
    }

    private Request generateRequest(RequestMethod method, FssApiVersion apiVersion, String authHeader, String path, Map<String, String> parameters, String ifMatch, RequestBody body) throws AnywhereException {
        Request.Builder builder = new Request.Builder().url(this.getUrl(path, parameters)).method(method.name(), body).addHeader("X-HCPAW-FSS-API-VERSION", apiVersion.getVersionString());
        if (!Strings.isNullOrEmpty((String)authHeader)) {
            builder.addHeader(HTTP_HEADER_AUTHORIZATION, authHeader);
        }
        if (!Strings.isNullOrEmpty((String)ifMatch)) {
            builder.addHeader("If-Match", ifMatch).build();
        }
        return builder.build();
    }

    private HttpUrl getUrl(String path, Map<String, String> parameters) throws AnywhereException {
        HttpUrl.Builder builder = this.serverUrl.newBuilder().encodedPath(path);
        if (parameters != null && !parameters.isEmpty()) {
            parameters.entrySet().forEach(entry -> {
                String entryValue;
                String entryKey;
                try {
                    entryKey = URLEncoder.encode((String)entry.getKey(), UTF_8);
                    entryValue = URLEncoder.encode((String)entry.getValue(), UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    entryKey = (String)entry.getKey();
                    entryValue = (String)entry.getValue();
                }
                builder.addEncodedQueryParameter(entryKey, entryValue);
            });
        }
        return builder.build();
    }

    private static HttpUrl normalizeServerName(String server) throws AnywhereException {
        HttpUrl serverUrl = HttpUrl.parse((String)server);
        if (serverUrl == null) {
            throw new AnywhereException("Could not parse url", "Invalid server url");
        }
        return serverUrl;
    }

    private static RequestBody getStreamingRequestBody(final InputStream body) {
        return new RequestBody(){

            public MediaType contentType() {
                return MEDIA_TYPE_APPLICATION_OCTETSTREAM;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)body);){
                    sink.writeAll(source);
                }
            }
        };
    }

    private static String basicAuthHeader(String username, String password) {
        String token = Base64.getUrlEncoder().encodeToString(String.format("%s:%s", username, password).getBytes());
        return AuthToken.toAuthHeaderValue("Basic", token);
    }

    private static interface SuccessfulResponseHandler<T> {
        public T handleResponse(Response var1) throws IOException, AnywhereException;
    }

    protected static class Builder {
        private HttpUrl serverUrl;
        private int maxIdleConnections = 5;
        private long keepAliveDuration = 1L;
        private TimeUnit keepAliveTimeUnit = TimeUnit.MINUTES;
        private long readTimeoutDuration = 10L;
        private TimeUnit readTimeoutTimeUnit = TimeUnit.MINUTES;
        private long writeTimeoutDuration = 10L;
        private TimeUnit writeTimeoutTimeUnit = TimeUnit.MINUTES;
        private SSLSocketFactory sslSocketFactory = null;
        private boolean skipHostnameVerification = false;
        private Proxy proxy;

        protected Builder(String serverUrl) throws AnywhereException {
            this.serverUrl = AnywhereConnector.normalizeServerName(serverUrl);
        }

        protected AnywhereConnector build() {
            return new AnywhereConnector(this.serverUrl, this.getClient());
        }

        protected Builder server(String server) throws AnywhereException {
            this.serverUrl = AnywhereConnector.normalizeServerName(server);
            return this;
        }

        protected Builder maxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        protected Builder keepAliveDuration(long keepAliveDuration, TimeUnit timeUnit) {
            this.keepAliveDuration = keepAliveDuration;
            this.keepAliveTimeUnit = timeUnit;
            return this;
        }

        protected Builder useKeyStore(KeyStore keyStore) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
            this.sslSocketFactory = new DelegatingSSLSocketFactory(DelegatingTrustManager.getInstance(keyStore));
            return this;
        }

        protected Builder useCertificateChain(X509Certificate[] certChain) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
            this.sslSocketFactory = new DelegatingSSLSocketFactory(DelegatingTrustManager.getInstance(certChain));
            return this;
        }

        protected Builder insecureSSL() throws KeyManagementException, NoSuchAlgorithmException {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            this.sslSocketFactory = sslContext.getSocketFactory();
            return this;
        }

        protected Builder useSSLContext(SSLContext sslContext) throws KeyManagementException, NoSuchAlgorithmException {
            this.sslSocketFactory = sslContext.getSocketFactory();
            return this;
        }

        protected Builder skipHostnameVerification() {
            this.skipHostnameVerification = true;
            return this;
        }

        protected Builder readTimeoutDuration(long readTimeoutDuration, TimeUnit timeUnit) {
            this.readTimeoutDuration = readTimeoutDuration;
            this.readTimeoutTimeUnit = timeUnit;
            return this;
        }

        protected Builder writeTimeoutDuration(long writeTimeoutDuration, TimeUnit timeUnit) {
            this.writeTimeoutDuration = writeTimeoutDuration;
            this.writeTimeoutTimeUnit = timeUnit;
            return this;
        }

        protected Builder proxy(String hostname, int port) {
            return this.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port)));
        }

        protected Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        private OkHttpClient getClient() {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(this.maxIdleConnections, this.keepAliveDuration, this.keepAliveTimeUnit)).readTimeout(this.readTimeoutDuration, this.readTimeoutTimeUnit).writeTimeout(this.writeTimeoutDuration, this.writeTimeoutTimeUnit);
            if (this.sslSocketFactory != null) {
                builder.sslSocketFactory(this.sslSocketFactory);
            }
            if (this.skipHostnameVerification) {
                builder.hostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            if (this.proxy != null) {
                builder.proxy(this.proxy);
            }
            return builder.build();
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

