/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.google.common.collect.Maps;
import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.ConflictListing;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.model.FileHistoryListingRequest;
import com.hds.hcpaw.fss.api.model.FileReadRequest;
import com.hds.hcpaw.fss.api.model.FileRestoreRequest;
import com.hds.hcpaw.fss.api.model.FileVersionListing;
import com.hds.hcpaw.fss.api.model.FileVersionPromoteRequest;
import com.hds.hcpaw.fss.api.model.InputStreamResult;
import com.hds.hcpaw.fss.api.model.LinkAccessListing;
import com.hds.hcpaw.fss.api.model.PageAction;
import com.hds.hcpaw.fss.api.model.ReadAccessListing;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class AnywhereFileAPI {
    private static final String FILE_URI = "/fss/public/file";
    private AnywhereConnector conn;

    protected AnywhereFileAPI(AnywhereConnector connector) {
        this.conn = connector;
    }

    public Entry read(AuthToken authToken, String path, String etag, OutputStream out) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileReadRequest body = FileReadRequest.create(apiVersion, path, etag, false);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/stream/read", null, body, out, Entry.class, "X-HCPAW-FSS-API-ENTRY");
        });
    }

    public Entry read(AuthToken authToken, String path, String etag, Boolean forceDownload, OutputStream out) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileReadRequest body = FileReadRequest.create(apiVersion, path, etag, forceDownload);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/stream/read", null, body, out, Entry.class, "X-HCPAW-FSS-API-ENTRY");
        });
    }

    @Deprecated
    public InputStreamResult<Entry> read(AuthToken authToken, String path, String etag) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileReadRequest body = FileReadRequest.create(apiVersion, path, etag, false);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/stream/read", null, body, Entry.class, "X-HCPAW-FSS-API-ENTRY");
        });
    }

    public Entry upload(AuthToken authToken, String path, Long size, String hash, boolean createParents, InputStream contentIn) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        HashMap params = Maps.newHashMap();
        params.put("path", path);
        if (size != null) {
            params.put("size", Long.toString(size));
        }
        if (hash != null) {
            params.put("hash", hash);
        }
        params.put("createParents", Boolean.toString(createParents));
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            Entry result = this.conn.invokeWithStream(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/stream/create", params, null, contentIn, Entry.class);
            return result;
        });
    }

    public Entry update(AuthToken authToken, String path, Long size, String hash, String etag, InputStream contentIn) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        HashMap params = Maps.newHashMap();
        params.put("path", path);
        if (size != null) {
            params.put("size", Long.toString(size));
        }
        if (hash != null) {
            params.put("hash", hash);
        }
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            Entry result = this.conn.invokeWithStream(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/stream/update", params, etag, contentIn, Entry.class);
            return result;
        });
    }

    public FileVersionListing listVersions(AuthToken authToken, String path, Boolean showPrivate, String pageToken, Integer pageSize, PageAction pageAction) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileHistoryListingRequest body = FileHistoryListingRequest.create(apiVersion, path, showPrivate, pageToken, pageSize, pageAction);
            FileVersionListing result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/version/list", null, body, FileVersionListing.class);
            return result;
        });
    }

    public ReadAccessListing listReadHistory(AuthToken authToken, String path, Boolean showPrivate, String pageToken, Integer pageSize, PageAction pageAction) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileHistoryListingRequest body = FileHistoryListingRequest.create(apiVersion, path, showPrivate, pageToken, pageSize, pageAction);
            ReadAccessListing result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/readAccess/list", null, body, ReadAccessListing.class);
            return result;
        });
    }

    public LinkAccessListing listLinkReadHistory(AuthToken authToken, String path, Boolean showPrivate, String pageToken, Integer pageSize, PageAction pageAction) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileHistoryListingRequest body = FileHistoryListingRequest.create(apiVersion, path, showPrivate, pageToken, pageSize, pageAction);
            LinkAccessListing result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/linkAccess/list", null, body, LinkAccessListing.class);
            return result;
        });
    }

    public Entry promoteVersion(AuthToken authToken, String path, String etag) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileVersionPromoteRequest body = FileVersionPromoteRequest.create(apiVersion, path, etag);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/version/promote", null, body, Entry.class);
        });
    }

    public Entry restore(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FileRestoreRequest body = FileRestoreRequest.create(apiVersion, path);
            Entry entry = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/restore", null, body, Entry.class);
            return entry;
        });
    }

    public ConflictListing listConflicts(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> this.conn.invokeNoBody(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/file/conflict/list", null, ConflictListing.class));
    }
}

