/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.model.FolderCreateRequest;
import com.hds.hcpaw.fss.api.model.FolderListing;
import com.hds.hcpaw.fss.api.model.FolderListingRequest;
import com.hds.hcpaw.fss.api.model.FolderRestoreRequest;
import com.hds.hcpaw.fss.api.model.FolderSize;
import com.hds.hcpaw.fss.api.model.FolderSizeRequest;
import java.io.IOException;

public class AnywhereFolderAPI {
    public static final boolean DEFAULT_CREATE_PARENTS = false;
    private static final String FOLDER_URI = "/fss/public/folder";
    private AnywhereConnector conn;

    protected AnywhereFolderAPI(AnywhereConnector connector) {
        this.conn = connector;
    }

    public Entry create(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.create(authToken, path, false);
    }

    public Entry create(AuthToken authToken, String path, boolean createParents) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FolderCreateRequest body = FolderCreateRequest.create(apiVersion, path, createParents, null, null, null);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/folder/create", null, body, Entry.class);
        });
    }

    public FolderListing listEntries(AuthToken authToken, String path, String pageToken, int pageSize) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.listEntries(authToken, path, pageToken, pageSize, null, null);
    }

    public FolderListing listEntries(AuthToken authToken, String path, String pageToken, int pageSize, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FolderListingRequest body = FolderListingRequest.create(apiVersion, path, pageToken, pageSize, null, null, sortingCriterion, sortingDirection);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/folder/entries/list", null, body, FolderListing.class);
        });
    }

    public FolderListing listEntriesAtTime(AuthToken authToken, String path, Long viewAtTime, String pageToken, int pageSize) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.listEntriesAtTime(authToken, path, viewAtTime, pageToken, pageSize, null, null);
    }

    public FolderListing listEntriesAtTime(AuthToken authToken, String path, Long viewAtTime, String pageToken, int pageSize, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FolderListingRequest body = FolderListingRequest.create(apiVersion, path, pageToken, pageSize, viewAtTime, null, sortingCriterion, sortingDirection);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/folder/entries/list", null, body, FolderListing.class);
        });
    }

    public FolderListing listEntriesIncludeDeleted(AuthToken authToken, String path, String pageToken, int pageSize) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.listEntriesIncludeDeleted(authToken, path, pageToken, pageSize, null, null);
    }

    public FolderListing listEntriesIncludeDeleted(AuthToken authToken, String path, String pageToken, int pageSize, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FolderListingRequest body = FolderListingRequest.create(apiVersion, path, pageToken, pageSize, null, true, sortingCriterion, sortingDirection);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/folder/entries/list", null, body, FolderListing.class);
        });
    }

    public Entry restore(AuthToken authToken, String path, int deltaSeconds) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FolderRestoreRequest body = FolderRestoreRequest.create(apiVersion, path, deltaSeconds);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/folder/restore", null, body, Entry.class);
        });
    }

    public FolderSize getSize(AuthToken authToken, String path, long pointInTime) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            FolderSizeRequest body = FolderSizeRequest.create(apiVersion, path, pointInTime);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/folder/getSize", null, body, FolderSize.class);
        });
    }
}

