/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.google.common.collect.Maps;
import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.model.FolderListingRequest;
import com.hds.hcpaw.fss.api.model.Link;
import com.hds.hcpaw.fss.api.model.LinkBrowseListing;
import com.hds.hcpaw.fss.api.model.LinkBrowseRequest;
import com.hds.hcpaw.fss.api.model.LinkCopyToLocalRequest;
import com.hds.hcpaw.fss.api.model.LinkCreateRequest;
import com.hds.hcpaw.fss.api.model.LinkDeleteRequest;
import com.hds.hcpaw.fss.api.model.LinkFileReadRequest;
import com.hds.hcpaw.fss.api.model.LinkListRequest;
import com.hds.hcpaw.fss.api.model.LinkListing;
import com.hds.hcpaw.fss.api.model.LinkMultiDownloadRequest;
import com.hds.hcpaw.fss.api.model.LinkPathMetadataRequest;
import com.hds.hcpaw.fss.api.model.LinkPermission;
import com.hds.hcpaw.fss.api.model.LinkUpdateRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AnywhereLinkAPI {
    private static final String LINK_URI = "/fss/public/link";
    private AnywhereConnector conn;

    protected AnywhereLinkAPI(AnywhereConnector connector) {
        this.conn = connector;
    }

    @Deprecated
    public Link create(AuthToken authToken, String path, Integer expirationDays, Boolean publicLink, boolean accessCode, Set<LinkPermission> permissions) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkCreateRequest body = LinkCreateRequest.create(apiVersion, path, expirationDays, publicLink, accessCode, permissions);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/create", null, body, Link.class);
        });
    }

    public Link create(AuthToken authToken, String path, Integer expirationDays, Boolean publicLink, boolean accessCode, Set<LinkPermission> permissions, String uniqueId) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkCreateRequest body = LinkCreateRequest.create(apiVersion, path, expirationDays, publicLink, accessCode, permissions, uniqueId);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/create", null, body, Link.class);
        });
    }

    @Deprecated
    public void delete(AuthToken authToken, String path, String url) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkDeleteRequest body = LinkDeleteRequest.create(apiVersion, path, url);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/delete", null, body);
            return null;
        });
    }

    public void delete(AuthToken authToken, String url) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkDeleteRequest body = LinkDeleteRequest.create(apiVersion, url);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/delete", null, body);
            return null;
        });
    }

    @Deprecated
    public Link update(AuthToken authToken, String path, String url, boolean updateAccessCode, Long expirationDate) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkUpdateRequest body = LinkUpdateRequest.create(apiVersion, path, url, updateAccessCode, expirationDate);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/update", null, body, Link.class);
        });
    }

    public Link update(AuthToken authToken, String url, boolean updateAccessCode, Long expirationDate) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkUpdateRequest body = LinkUpdateRequest.create(apiVersion, url, updateAccessCode, expirationDate);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/update", null, body, Link.class);
        });
    }

    public LinkListing list(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.list(authToken, null, null, null, null, null);
    }

    public LinkListing list(AuthToken authToken, String filter, String pageToken, Integer pageSize, LinkListRequest.LinkSortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkListRequest body = LinkListRequest.create(apiVersion, pageToken, pageSize, sortingCriterion, sortingDirection, filter);
            LinkListing result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/list", null, body, LinkListing.class);
            return result;
        });
    }

    public Entry getPublicLinkPathMetadata(AuthToken authToken, String linkToken, String itemName, String accessCode, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkPathMetadataRequest body = LinkPathMetadataRequest.create(apiVersion, linkToken, itemName, accessCode, path);
            Entry result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/public/path/info/get", null, body, Entry.class);
            return result;
        });
    }

    public Entry getPrivateLinkPathMetadata(AuthToken authToken, String linkToken, String itemName, String accessCode, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkPathMetadataRequest body = LinkPathMetadataRequest.create(apiVersion, linkToken, itemName, accessCode, path);
            Entry result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/private/path/info/get", null, body, Entry.class);
            return result;
        });
    }

    public LinkBrowseListing browsePublicLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, String pageToken, int pageSize, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkBrowseRequest body = LinkBrowseRequest.create(apiVersion, linkToken, itemName, accessCode, path, pageSize, pageToken, sortingCriterion, sortingDirection);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/public/browse", null, body, LinkBrowseListing.class);
        });
    }

    public LinkBrowseListing browsePrivateLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, String pageToken, int pageSize, FolderListingRequest.SortingCriterion sortingCriterion, FolderListingRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkBrowseRequest body = LinkBrowseRequest.create(apiVersion, linkToken, itemName, accessCode, path, pageSize, pageToken, sortingCriterion, sortingDirection);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/private/browse", null, body, LinkBrowseListing.class);
        });
    }

    public Entry readFilePublicLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, String etag, OutputStream out) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkFileReadRequest body = LinkFileReadRequest.create(apiVersion, linkToken, itemName, accessCode, path, etag);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/public/stream/read", null, body, out, Entry.class, "X-HCPAW-FSS-API-ENTRY");
        });
    }

    public Entry readFilePrivateLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, String etag, OutputStream out) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkFileReadRequest body = LinkFileReadRequest.create(apiVersion, linkToken, itemName, accessCode, path, etag);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/private/stream/read", null, body, out, Entry.class, "X-HCPAW-FSS-API-ENTRY");
        });
    }

    public Entry createFilePublicLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, Long size, String hash, Boolean createParents, InputStream contentIn) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        HashMap params = Maps.newHashMap();
        params.put("path", path);
        params.put("itemName", itemName);
        params.put("linkToken", linkToken);
        if (accessCode != null) {
            params.put("accessCode", accessCode);
        }
        if (size != null) {
            params.put("size", Long.toString(size));
        }
        if (hash != null) {
            params.put("hash", hash);
        }
        if (createParents != null) {
            params.put("createParents", Boolean.toString(createParents));
        }
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            Entry result = this.conn.invokeWithStream(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/public/stream/create", params, null, contentIn, Entry.class);
            return result;
        });
    }

    public Entry createFilePrivateLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, Long size, String hash, Boolean createParents, InputStream contentIn) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        HashMap params = Maps.newHashMap();
        params.put("path", path);
        params.put("itemName", itemName);
        params.put("linkToken", linkToken);
        if (accessCode != null) {
            params.put("accessCode", accessCode);
        }
        if (size != null) {
            params.put("size", Long.toString(size));
        }
        if (hash != null) {
            params.put("hash", hash);
        }
        if (createParents != null) {
            params.put("createParents", Boolean.toString(createParents));
        }
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            Entry result = this.conn.invokeWithStream(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/private/stream/create", params, null, contentIn, Entry.class);
            return result;
        });
    }

    public void multiFileDownloadPublicLink(AuthToken authToken, List<String> pathList, String linkToken, String itemName, String accessCode, OutputStream out) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkMultiDownloadRequest body = LinkMultiDownloadRequest.create(apiVersion, linkToken, itemName, accessCode, pathList);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/public/multiDownload", null, body, out, Void.class, null);
        });
    }

    public void multiFileDownloadPrivateLink(AuthToken authToken, List<String> pathList, String linkToken, String itemName, String accessCode, OutputStream out) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkMultiDownloadRequest body = LinkMultiDownloadRequest.create(apiVersion, linkToken, itemName, accessCode, pathList);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/private/multiDownload", null, body, out, Void.class, null);
        });
    }

    public Entry updateFilePublicLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, Long size, String hash, String etag, InputStream contentIn) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        HashMap params = Maps.newHashMap();
        params.put("linkToken", linkToken);
        params.put("itemName", itemName);
        if (accessCode != null) {
            params.put("accessCode", accessCode);
        }
        params.put("path", path);
        if (size != null) {
            params.put("size", Long.toString(size));
        }
        if (hash != null) {
            params.put("hash", hash);
        }
        params.put("etag", etag);
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            Entry result = this.conn.invokeWithStream(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/public/stream/update", params, etag, contentIn, Entry.class);
            return result;
        });
    }

    public Entry updateFilePrivateLink(AuthToken authToken, String linkToken, String itemName, String accessCode, String path, Long size, String hash, String etag, InputStream contentIn) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        HashMap params = Maps.newHashMap();
        params.put("linkToken", linkToken);
        params.put("itemName", itemName);
        if (accessCode != null) {
            params.put("accessCode", accessCode);
        }
        params.put("path", path);
        if (size != null) {
            params.put("size", Long.toString(size));
        }
        if (hash != null) {
            params.put("hash", hash);
        }
        params.put("etag", etag);
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            Entry result = this.conn.invokeWithStream(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/private/stream/update", params, etag, contentIn, Entry.class);
            return result;
        });
    }

    public void copyFilesToLocalPublicLink(AuthToken authToken, String linkToken, String itemName, String accessCode, List<String> pathList, String destinationPath) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkCopyToLocalRequest body = LinkCopyToLocalRequest.create(apiVersion, linkToken, itemName, accessCode, pathList, destinationPath);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/public/copyToLocal", null, body);
            return null;
        });
    }

    public void copyFilesToLocalPrivateLink(AuthToken authToken, String linkToken, String itemName, String accessCode, List<String> pathList, String destinationPath) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            LinkCopyToLocalRequest body = LinkCopyToLocalRequest.create(apiVersion, linkToken, itemName, accessCode, pathList, destinationPath);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/link/private/copyToLocal", null, body);
            return null;
        });
    }
}

