/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.DeletePathRequest;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.model.EntryIdentifier;
import com.hds.hcpaw.fss.api.model.LinkListing;
import com.hds.hcpaw.fss.api.model.ListPathLinksRequest;
import com.hds.hcpaw.fss.api.model.MovePathRequest;
import com.hds.hcpaw.fss.api.model.MultiDeletePathRequest;
import com.hds.hcpaw.fss.api.model.MultiDeletePathResult;
import com.hds.hcpaw.fss.api.model.PathMetadataGetRequest;
import com.hds.hcpaw.fss.api.model.PathSearchResult;
import com.hds.hcpaw.fss.api.model.SearchPathRequest;
import java.io.IOException;
import java.util.List;

public class AnywherePathAPI {
    public static final boolean DEFAULT_RECURSIVE_DELETE = false;
    public static final boolean DEFAULT_CREATE_PARENTS = false;
    private static final String PATH_URI = "/fss/public/path";
    private AnywhereConnector conn;

    protected AnywherePathAPI(AnywhereConnector connector) {
        this.conn = connector;
    }

    public void delete(AuthToken authToken, String path, String etag) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        this.delete(authToken, path, etag, false);
    }

    public void delete(AuthToken authToken, String path, String etag, boolean recursive) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            DeletePathRequest body = DeletePathRequest.create(apiVersion, path, recursive, etag);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/path/delete", null, body);
            return null;
        });
    }

    public MultiDeletePathResult multiDelete(AuthToken authToken, List<EntryIdentifier> entryList, Boolean recursive) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            MultiDeletePathRequest body = MultiDeletePathRequest.create(apiVersion, entryList, recursive);
            MultiDeletePathResult result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/path/multiDelete", null, body, MultiDeletePathResult.class);
            return result;
        });
    }

    public Entry move(AuthToken authToken, String sourcePath, String destPath, String etag) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.move(authToken, sourcePath, destPath, etag, false);
    }

    public Entry move(AuthToken authToken, String sourcePath, String destPath, String etag, boolean createParents) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            MovePathRequest body = MovePathRequest.create(apiVersion, sourcePath, destPath, etag, createParents);
            Entry result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/path/move", null, body, Entry.class);
            return result;
        });
    }

    public Entry getInfo(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            PathMetadataGetRequest body = PathMetadataGetRequest.create(apiVersion, path, false);
            Entry result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/path/info/get", null, body, Entry.class);
            return result;
        });
    }

    public Entry getInfo(AuthToken authToken, String path, boolean includeDeleted) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            PathMetadataGetRequest body = PathMetadataGetRequest.create(apiVersion, path, includeDeleted);
            Entry result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/path/info/get", null, body, Entry.class);
            return result;
        });
    }

    public PathSearchResult search(AuthToken authToken, String path, String substring, Integer maxResults) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.search(authToken, path, substring, maxResults, null, null);
    }

    public PathSearchResult search(AuthToken authToken, String path, String substring, Integer maxResults, Boolean includeDeleted, Long pointInTime) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            SearchPathRequest body = SearchPathRequest.create(apiVersion, path, substring, maxResults, includeDeleted, pointInTime);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/path/search", null, body, PathSearchResult.class);
        });
    }

    public LinkListing listLinks(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ListPathLinksRequest body = ListPathLinksRequest.create(apiVersion, path);
            LinkListing result = this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/path/listLinks", null, body, LinkListing.class);
            return result;
        });
    }
}

