/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.model.GroupMembersListing;
import com.hds.hcpaw.fss.api.model.InvitationListing;
import com.hds.hcpaw.fss.api.model.InviteRequest;
import com.hds.hcpaw.fss.api.model.ListGroupMembersRequest;
import com.hds.hcpaw.fss.api.model.PreserveMembershipRequest;
import com.hds.hcpaw.fss.api.model.ShareConvertRequest;
import com.hds.hcpaw.fss.api.model.ShareCreateRequest;
import com.hds.hcpaw.fss.api.model.ShareGroupListRequest;
import com.hds.hcpaw.fss.api.model.ShareInvitationAcceptRequest;
import com.hds.hcpaw.fss.api.model.ShareInvitationCancelRequest;
import com.hds.hcpaw.fss.api.model.ShareInvitationRejectRequest;
import com.hds.hcpaw.fss.api.model.ShareInviteSearchRequest;
import com.hds.hcpaw.fss.api.model.ShareInviteSearchResult;
import com.hds.hcpaw.fss.api.model.ShareLeaveRequest;
import com.hds.hcpaw.fss.api.model.ShareMemberListRequest;
import com.hds.hcpaw.fss.api.model.ShareMemberListing;
import com.hds.hcpaw.fss.api.model.ShareRemoveGroupRequest;
import com.hds.hcpaw.fss.api.model.ShareRemoveMemberRequest;
import com.hds.hcpaw.fss.api.model.ShareRole;
import com.hds.hcpaw.fss.api.model.ShareSettingsUpdateRequest;
import com.hds.hcpaw.fss.api.model.ShareSyncMembershipRequest;
import com.hds.hcpaw.fss.api.model.ShareUserListRequest;
import com.hds.hcpaw.fss.api.model.SharedFolder;
import com.hds.hcpaw.fss.api.model.SharedFolderListing;
import com.hds.hcpaw.fss.api.model.TeamFolderApproveRequest;
import com.hds.hcpaw.fss.api.model.TeamFolderCancelRequest;
import com.hds.hcpaw.fss.api.model.TeamFolderCreateRequest;
import com.hds.hcpaw.fss.api.model.TeamFolderDeleteRequest;
import com.hds.hcpaw.fss.api.model.TeamFolderUpdateRequest;
import com.hds.hcpaw.fss.api.model.UnshareFolderRequest;
import java.io.IOException;

public class AnywhereShareAPI {
    private static final String SHARE_URI = "/fss/public/share";
    private AnywhereConnector conn;

    protected AnywhereShareAPI(AnywhereConnector connector) {
        this.conn = connector;
    }

    public SharedFolder create(AuthToken authToken, String path, String label) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareCreateRequest body = ShareCreateRequest.create(apiVersion, path, label);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/create", null, body, SharedFolder.class);
        });
    }

    public SharedFolder invite(AuthToken authToken, String path, String uniqueId, String providerId, ShareRole role) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            InviteRequest body = InviteRequest.create(apiVersion, path, uniqueId, providerId, role);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/invite", null, body, SharedFolder.class);
        });
    }

    public InvitationListing listInvitations(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> this.conn.invokeNoBody(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/listInvitations", null, InvitationListing.class));
    }

    public SharedFolder acceptInvitation(AuthToken authToken, String fsId, boolean sync) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareInvitationAcceptRequest body = ShareInvitationAcceptRequest.create(apiVersion, fsId, sync);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/acceptInvitation", null, body, SharedFolder.class);
        });
    }

    public void rejectInvitation(AuthToken authToken, String fsId) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareInvitationRejectRequest body = ShareInvitationRejectRequest.create(apiVersion, fsId);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/rejectInvitation", null, body);
            return null;
        });
    }

    public void cancelInvitation(AuthToken authToken, String path, String uniqueId, String providerId) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareInvitationCancelRequest body = ShareInvitationCancelRequest.create(apiVersion, path, uniqueId, providerId);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/cancelInvitation", null, body);
            return null;
        });
    }

    public Entry unshareFolder(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            UnshareFolderRequest body = UnshareFolderRequest.create(apiVersion, path);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/unshare", null, body, Entry.class);
        });
    }

    public GroupMembersListing listGroupMembers(AuthToken authToken, String name, String providerId) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ListGroupMembersRequest body = ListGroupMembersRequest.create(apiVersion, name, providerId);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/listGroupMembers", null, body, GroupMembersListing.class);
        });
    }

    public Void leaveShare(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareLeaveRequest body = ShareLeaveRequest.create(apiVersion, path);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/leave", null, body, Void.class);
        });
    }

    public void removeMember(AuthToken authToken, String path, String uniqueId, String providerId) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareRemoveMemberRequest body = ShareRemoveMemberRequest.create(apiVersion, path, uniqueId, providerId);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/removeMember", null, body);
            return null;
        });
    }

    public void removeGroup(AuthToken authToken, String path, String uniqueId, String providerId) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareRemoveGroupRequest body = ShareRemoveGroupRequest.create(apiVersion, path, uniqueId, providerId);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/removeGroup", null, body);
            return null;
        });
    }

    public SharedFolder updateShareSettings(AuthToken authToken, String path, boolean sync) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareSettingsUpdateRequest body = ShareSettingsUpdateRequest.create(apiVersion, path, sync);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/updateSettings", null, body, SharedFolder.class);
        });
    }

    public SharedFolder createTeamFolder(AuthToken authToken, String path, String label, String contact, Long quotaBytes) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            TeamFolderCreateRequest body = TeamFolderCreateRequest.create(apiVersion, path, label, contact, quotaBytes);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/team/create", null, body, SharedFolder.class);
        });
    }

    public SharedFolder convertToTeamFolder(AuthToken authToken, String path, String contact, Long quotaBytes) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareConvertRequest body = ShareConvertRequest.create(apiVersion, path, contact, quotaBytes);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/convert", null, body, SharedFolder.class);
        });
    }

    public SharedFolder cancelTeamFolderRequest(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            TeamFolderCancelRequest body = TeamFolderCancelRequest.create(apiVersion, path);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/team/cancel", null, body, SharedFolder.class);
        });
    }

    public SharedFolder approveTeamFolderRequest(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            TeamFolderApproveRequest body = TeamFolderApproveRequest.create(apiVersion, path);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/team/approve", null, body, SharedFolder.class);
        });
    }

    public SharedFolder updateTeamFolder(AuthToken authToken, String path, String contact, Long quotaBytes) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            TeamFolderUpdateRequest body = TeamFolderUpdateRequest.create(apiVersion, path, contact, quotaBytes);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/team/settings/update", null, body, SharedFolder.class);
        });
    }

    public void deleteTeamFolder(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        ApiVersionedAction.run(this.conn, apiVersion -> {
            TeamFolderDeleteRequest body = TeamFolderDeleteRequest.create(apiVersion, path);
            this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/team/delete", null, body);
            return null;
        });
    }

    public SharedFolderListing listSharedFolders(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/list", null, null, SharedFolderListing.class));
    }

    public ShareMemberListing listShareMembers(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return this.listShareMembers(authToken, path, null, null);
    }

    public ShareMemberListing listShareMembers(AuthToken authToken, String path, String pageToken, Integer pageSize) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareMemberListRequest body = ShareMemberListRequest.create(apiVersion, path, pageToken, pageSize, null, null);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/members", null, body, ShareMemberListing.class);
        });
    }

    public ShareMemberListing listShareMembers(AuthToken authToken, String path, String pageToken, Integer pageSize, ShareMemberListRequest.SortingCriterion sortingCriterion, ShareMemberListRequest.SortingDirection sortingDirection) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareMemberListRequest body = ShareMemberListRequest.create(apiVersion, path, pageToken, pageSize, sortingCriterion, sortingDirection);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/members", null, body, ShareMemberListing.class);
        });
    }

    public ShareMemberListing listShareUsers(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareUserListRequest body = ShareUserListRequest.create(apiVersion, path);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/users", null, body, ShareMemberListing.class);
        });
    }

    public SharedFolder syncMembership(AuthToken authToken, String path, boolean increaseRole, boolean inviteDeclined) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareSyncMembershipRequest body = ShareSyncMembershipRequest.create(apiVersion, path, increaseRole, inviteDeclined);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/syncMembership", null, body, SharedFolder.class);
        });
    }

    public ShareMemberListing preserveMembership(AuthToken authToken, String path, boolean removeGroups) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            PreserveMembershipRequest body = PreserveMembershipRequest.create(apiVersion, path, removeGroups);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/preserveMembership", null, body, ShareMemberListing.class);
        });
    }

    public ShareMemberListing listShareGroups(AuthToken authToken, String path) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareGroupListRequest body = ShareGroupListRequest.create(apiVersion, path);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/groups", null, body, ShareMemberListing.class);
        });
    }

    public ShareInviteSearchResult searchInvite(AuthToken authToken, String path, String filter) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            ShareInviteSearchRequest body = ShareInviteSearchRequest.create(apiVersion, path, filter);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/share/invite/search", null, body, ShareInviteSearchResult.class);
        });
    }
}

