/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api;

import com.hds.hcpaw.fss.api.AnywhereConnector;
import com.hds.hcpaw.fss.api.ApiVersionedAction;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthToken;
import com.hds.hcpaw.fss.api.model.FilesystemListing;
import com.hds.hcpaw.fss.api.model.RestorePointListing;
import com.hds.hcpaw.fss.api.model.User;
import com.hds.hcpaw.fss.api.model.UserSettingsUpdateRequest;
import java.io.IOException;

public class AnywhereUserAPI {
    private static final String USER_URI = "/fss/public/user";
    private AnywhereConnector conn;

    protected AnywhereUserAPI(AnywhereConnector connector) {
        this.conn = connector;
    }

    public User getInfo(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> this.conn.invokeNoBody(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/user/get", null, User.class));
    }

    public User updateSetting(AuthToken authToken, String email, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, Boolean openFilesOnClick, Boolean showSingleClickUserGuide) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> {
            UserSettingsUpdateRequest body = UserSettingsUpdateRequest.create(apiVersion, email, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, openFilesOnClick, showSingleClickUserGuide);
            return this.conn.invokeWithObject(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/user/settings/update", null, body, User.class);
        });
    }

    public FilesystemListing listFilesystems(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> this.conn.invokeNoBody(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/user/filesystems/list", null, FilesystemListing.class));
    }

    public RestorePointListing listRestorePoints(AuthToken authToken) throws AwUnsupportedApiVersionException, IOException, AnywhereException {
        return ApiVersionedAction.run(this.conn, apiVersion -> this.conn.invokeNoBody(AnywhereConnector.RequestMethod.POST, apiVersion, authToken, "/fss/public/user/restorePoints/list", null, RestorePointListing.class));
    }
}

