/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.conn;

import com.hds.hcpaw.fss.api.conn.DelegatingTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class DelegatingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLContext sslContext = SSLContext.getInstance("TLS");
    private final DelegatingTrustManager trustManager;

    public DelegatingSSLSocketFactory(DelegatingTrustManager trustManager) throws KeyManagementException, NoSuchAlgorithmException {
        this.trustManager = trustManager;
        this.sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslContext.getSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSocketFactory().getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.sslContext.getSocketFactory().createSocket();
    }

    public void setAppCertificateChain(X509Certificate[] chain) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.trustManager.setApplicationCertificateChain(chain);
    }

    public void clearAppCertificateChain() {
        this.trustManager.clearApplicationCertificateChain();
    }
}

