/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.conn;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.hds.hcpaw.fss.api.exception.AwInvalidCertificateException;
import com.hds.hcpaw.fss.api.exception.AwUntrustedCertificateException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class DelegatingTrustManager
implements X509TrustManager {
    private static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    private static final int CHAIN_LENGTH_CHECK_VERSION_THRESHOLD = 3;
    private final Collection<X509TrustManager> systemTrustManagers = DelegatingTrustManager.getSystemTrustManagers();
    private Collection<X509TrustManager> appTrustManagers = Collections.emptyList();

    private DelegatingTrustManager() throws KeyStoreException, NoSuchAlgorithmException {
    }

    public static DelegatingTrustManager getInstance(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        DelegatingTrustManager trustManager = new DelegatingTrustManager();
        if (keyStore != null) {
            trustManager.setApplicationCertificateChain(keyStore);
        }
        return trustManager;
    }

    public static DelegatingTrustManager getInstance(X509Certificate[] chain) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        DelegatingTrustManager trustManager = new DelegatingTrustManager();
        if (chain != null) {
            trustManager.setApplicationCertificateChain(chain);
        }
        return trustManager;
    }

    public void setApplicationCertificateChain(X509Certificate[] chain) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Preconditions.checkNotNull((Object)chain);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE_PKCS12);
        keyStore.load(null);
        for (X509Certificate cert : chain) {
            if (cert == null) continue;
            keyStore.setCertificateEntry(cert.getSubjectX500Principal().getName().toLowerCase(Locale.ENGLISH), cert);
        }
        this.setApplicationCertificateChain(keyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationCertificateChain(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        Preconditions.checkNotNull((Object)keyStore);
        Collection<X509TrustManager> collection = this.appTrustManagers;
        synchronized (collection) {
            this.appTrustManagers = DelegatingTrustManager.getTrustManagers(keyStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearApplicationCertificateChain() {
        Collection<X509TrustManager> collection = this.appTrustManagers;
        synchronized (collection) {
            this.appTrustManagers = Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<X509TrustManager> getAppTrustManagers() {
        Collection<X509TrustManager> collection = this.appTrustManagers;
        synchronized (collection) {
            return this.appTrustManagers;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!DelegatingTrustManager.isClientChainTrusted(this.getAppTrustManagers(), chain, authType) && !DelegatingTrustManager.isClientChainTrusted(this.systemTrustManagers, chain, authType)) {
            throw new AwUntrustedCertificateException(chain);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!DelegatingTrustManager.isIssued(chain)) {
            throw new AwInvalidCertificateException(chain, AwInvalidCertificateException.Reason.NOT_ISSUED);
        }
        if (DelegatingTrustManager.isExpired(chain)) {
            throw new AwInvalidCertificateException(chain, AwInvalidCertificateException.Reason.EXPIRED);
        }
        for (int i = 1; i < chain.length; ++i) {
            int basicConstraints;
            if (chain[i].getVersion() < 3 || (basicConstraints = chain[i].getBasicConstraints()) >= i - 1) continue;
            throw new AwInvalidCertificateException(chain, AwInvalidCertificateException.Reason.CHAIN_TOO_LONG);
        }
        if (!DelegatingTrustManager.isServerChainTrusted(this.getAppTrustManagers(), chain, authType) && !DelegatingTrustManager.isServerChainTrusted(this.systemTrustManagers, chain, authType)) {
            if (chain.length > 0 && !DelegatingTrustManager.isSelfSignedCertificate(chain[chain.length - 1])) {
                throw new AwInvalidCertificateException(chain, AwInvalidCertificateException.Reason.UNTRUSTED_NOT_SELF_SIGNED);
            }
            throw new AwUntrustedCertificateException(chain);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList certs = Lists.newArrayList();
        certs.addAll(DelegatingTrustManager.getAcceptedIssuers(this.getAppTrustManagers()));
        certs.addAll(DelegatingTrustManager.getAcceptedIssuers(this.systemTrustManagers));
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    private static Collection<X509TrustManager> getSystemTrustManagers() throws KeyStoreException, NoSuchAlgorithmException {
        return DelegatingTrustManager.getTrustManagers(null);
    }

    private static Collection<X509TrustManager> getTrustManagers(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        ArrayList trustManagers = Lists.newArrayList();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            trustManagers.add((X509TrustManager)trustManager);
        }
        return Collections.unmodifiableCollection(trustManagers);
    }

    private static boolean isClientChainTrusted(Collection<X509TrustManager> trustManagers, X509Certificate[] chain, String authType) {
        for (X509TrustManager trustManager : trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
            }
        }
        return false;
    }

    private static boolean isServerChainTrusted(Collection<X509TrustManager> trustManagers, X509Certificate[] chain, String authType) {
        for (X509TrustManager trustManager : trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
            }
        }
        return false;
    }

    private static Collection<X509Certificate> getAcceptedIssuers(Collection<X509TrustManager> trustManagers) {
        ArrayList certs = Lists.newArrayList();
        for (X509TrustManager trustManager : trustManagers) {
            certs.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return certs;
    }

    private static boolean isIssued(X509Certificate[] chain) {
        Date now = new Date();
        for (X509Certificate cert : chain) {
            if (!now.before(cert.getNotBefore())) continue;
            return false;
        }
        return true;
    }

    private static boolean isExpired(X509Certificate[] chain) {
        Date now = new Date();
        for (X509Certificate cert : chain) {
            if (!now.after(cert.getNotAfter())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelfSignedCertificate(X509Certificate cert) {
        Principal issuer = cert.getIssuerDN();
        Principal subject = cert.getSubjectDN();
        return issuer.equals(subject);
    }
}

