/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.exception;

import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AnywhereHttpException;
import com.hds.hcpaw.fss.api.exception.AwAdditionalAuthenticationNeededException;
import com.hds.hcpaw.fss.api.exception.AwBadRequestException;
import com.hds.hcpaw.fss.api.exception.AwConflictException;
import com.hds.hcpaw.fss.api.exception.AwForbiddenException;
import com.hds.hcpaw.fss.api.exception.AwLimitExceededException;
import com.hds.hcpaw.fss.api.exception.AwNotFoundException;
import com.hds.hcpaw.fss.api.exception.AwRetryableException;
import com.hds.hcpaw.fss.api.exception.AwUnauthorizedException;
import com.hds.hcpaw.fss.api.exception.FssApiError;
import com.hds.hcpaw.fss.api.model.ErrorMessage;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnywhereExceptionFactory {
    private static final Logger LOGGER = Logger.getLogger(AnywhereExceptionFactory.class.getName());
    private static final String RESOURCE_BUNDLE_NAME = "com.hds.hcpaw.fss.api.exception.errorMessages";
    private static final String DEFAULT_ERROR_MESSAGE = "An unexpected error occurred";
    private static final String DEFAULT_ERROR_MESSAGE_KEY = "default_error_message";
    private static final String FSS_API_ERROR_KEY_PREFIX = "fssapierror.";
    private static ResourceBundle errorsBundle;
    private static String localizedDefaultErrorMessage;

    public static void throwHttpException(String statusMessage, int statusCode, Set<FssApiVersion> supportedVersions) throws AnywhereException {
        AnywhereExceptionFactory.throwHttpException(statusMessage, statusCode, null, supportedVersions);
    }

    public static void throwHttpException(String statusMessage, int statusCode, ErrorMessage errorMessage, Set<FssApiVersion> supportedVersions) throws AnywhereException {
        FssApiError apiError = errorMessage != null ? errorMessage.getError() : null;
        Class<? extends AnywhereHttpException> errorClass = apiError != null ? apiError.getErrorClass(statusCode) : AnywhereExceptionFactory.getErrorClass(statusCode);
        try {
            Constructor<? extends AnywhereHttpException> constructor = errorClass.getConstructor(String.class, Integer.TYPE, ErrorMessage.class, Set.class);
            throw constructor.newInstance(statusMessage, statusCode, errorMessage, supportedVersions);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AnywhereException(localizedDefaultErrorMessage, e);
        }
    }

    static Class<? extends AnywhereHttpException> getErrorClass(int statusCode) {
        if (statusCode == 400) {
            return AwBadRequestException.class;
        }
        if (statusCode == 401) {
            return AwUnauthorizedException.class;
        }
        if (statusCode == 403) {
            return AwForbiddenException.class;
        }
        if (statusCode == 404) {
            return AwNotFoundException.class;
        }
        if (statusCode == 409) {
            return AwConflictException.class;
        }
        if (statusCode == 413) {
            return AwLimitExceededException.class;
        }
        if (statusCode == 468) {
            return AwAdditionalAuthenticationNeededException.class;
        }
        if (statusCode >= 501) {
            return AwRetryableException.class;
        }
        return AnywhereHttpException.class;
    }

    public static String getHumanReadableErrorMessage(ErrorMessage error) {
        String errorMsg = localizedDefaultErrorMessage;
        if (error != null && error.getError() != null) {
            if (error.getError().getDefaultErrorMsg() != null) {
                errorMsg = error.getError().getDefaultErrorMsg();
            }
            if (errorsBundle != null) {
                try {
                    errorMsg = errorsBundle.getString(FSS_API_ERROR_KEY_PREFIX + error.getError().name());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return errorMsg;
    }

    public static String getDefaultHumanReadableErrorMessage() {
        return localizedDefaultErrorMessage;
    }

    static {
        localizedDefaultErrorMessage = DEFAULT_ERROR_MESSAGE;
        try {
            errorsBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, Locale.ENGLISH);
            localizedDefaultErrorMessage = errorsBundle.getString(DEFAULT_ERROR_MESSAGE_KEY);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "An error occurred getting the resource bundle com.hds.hcpaw.fss.api.exception.errorMessages");
        }
    }
}

