/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.exception;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.hds.commons.strings.Joiners;
import com.hds.hcpaw.fss.api.exception.AnywhereException;
import com.hds.hcpaw.fss.api.exception.AnywhereExceptionFactory;
import com.hds.hcpaw.fss.api.exception.FssApiError;
import com.hds.hcpaw.fss.api.model.ErrorMessage;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import java.util.Set;

public class AnywhereHttpException
extends AnywhereException {
    private static final long serialVersionUID = 8193130484097224363L;
    private final int statusCode;
    private final ErrorMessage errorMessage;
    private final Set<FssApiVersion> supportedVersions;

    public AnywhereHttpException(String message, int statusCode, Set<FssApiVersion> supportedVersions) {
        this(message, statusCode, null, supportedVersions);
    }

    public AnywhereHttpException(String message, int statusCode, ErrorMessage errorMessage, Set<FssApiVersion> supportedVersions) {
        super(AnywhereHttpException.createTechnicalMessage(message, statusCode, errorMessage, supportedVersions), AnywhereExceptionFactory.getHumanReadableErrorMessage(errorMessage));
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
        this.supportedVersions = supportedVersions;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public FssApiError getError() {
        return this.errorMessage != null ? this.errorMessage.getError() : null;
    }

    public String getDescription() {
        return this.errorMessage != null ? this.errorMessage.getDescription() : null;
    }

    public Set<FssApiVersion> getSupportedVersions() {
        return this.supportedVersions == null ? null : ImmutableSet.copyOf(this.supportedVersions);
    }

    private static String createTechnicalMessage(String message, int statusCode, ErrorMessage errorMessage, Set<FssApiVersion> supportedVersions) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Error %d", statusCode));
        if (!Strings.isNullOrEmpty((String)message)) {
            stringBuilder.append(": ").append(message);
        }
        if (errorMessage != null) {
            if (errorMessage.getError() != null) {
                stringBuilder.append(": ").append(errorMessage.getError().name());
            }
            if (!Strings.isNullOrEmpty((String)errorMessage.getDescription())) {
                stringBuilder.append(": ").append(errorMessage.getDescription());
            }
        }
        if (supportedVersions != null) {
            stringBuilder.append(": Supported versions: ").append(Joiners.comma().join(supportedVersions));
        }
        return stringBuilder.toString();
    }
}

