/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.exception;

import com.hds.hcpaw.fss.api.exception.AnywhereExceptionFactory;
import com.hds.hcpaw.fss.api.exception.AnywhereHttpException;
import com.hds.hcpaw.fss.api.exception.AwConflictException;
import com.hds.hcpaw.fss.api.exception.AwDirectoryNotEmptyException;
import com.hds.hcpaw.fss.api.exception.AwEntryLimitExceededException;
import com.hds.hcpaw.fss.api.exception.AwEntryVersionMismatchException;
import com.hds.hcpaw.fss.api.exception.AwFileNameLengthExceededException;
import com.hds.hcpaw.fss.api.exception.AwFileTooLargeException;
import com.hds.hcpaw.fss.api.exception.AwForbiddenException;
import com.hds.hcpaw.fss.api.exception.AwInvalidPathException;
import com.hds.hcpaw.fss.api.exception.AwInvalidRequestException;
import com.hds.hcpaw.fss.api.exception.AwJoinedSharesLimitExceeded;
import com.hds.hcpaw.fss.api.exception.AwLimitExceededException;
import com.hds.hcpaw.fss.api.exception.AwNotFoundException;
import com.hds.hcpaw.fss.api.exception.AwOverStorageQuotaException;
import com.hds.hcpaw.fss.api.exception.AwOwnedSharesLimitExceeded;
import com.hds.hcpaw.fss.api.exception.AwQueryCanceledException;
import com.hds.hcpaw.fss.api.exception.AwRemoveLastManagerException;
import com.hds.hcpaw.fss.api.exception.AwRemoveOwnerFromShareException;
import com.hds.hcpaw.fss.api.exception.AwRetryableException;
import com.hds.hcpaw.fss.api.exception.AwUnauthorizedException;

public enum FssApiError {
    NO_VALID_AUTH,
    INVALID_REQUEST(AwInvalidRequestException.class, "Invalid request"),
    INVALID_INPUT(AwInvalidRequestException.class, "Invalid input"),
    SHARING_PERMISSION_INVALID(AwInvalidRequestException.class, "The sharing permissions are invalid"),
    SEARCH_CRITERIA_TOO_SHORT(AwInvalidRequestException.class, "The search criteria is too short"),
    INVALID_TOKEN(AwUnauthorizedException.class, "Bad or expired access token"),
    NO_LOGIN(AwUnauthorizedException.class, "Did not login"),
    INVALID_PATH(AwInvalidPathException.class, "Invalid path"),
    DIRECTORY_NOT_EMPTY(AwDirectoryNotEmptyException.class, "This operation cannot be performed because the given directory is not empty"),
    FORBIDDEN_REQUEST(AwForbiddenException.class, "Forbidden request"),
    MOBILIZED_PATH(AwForbiddenException.class, "This operation is not permitted on a mobilized share"),
    MOBILIZED_RENAME(AwForbiddenException.class, "Moves into or out of mobilized shares are not allowed"),
    NESTED_SHARE(AwForbiddenException.class, "This operation cannot be performed because it would result in a shared folder inside another shared folder"),
    CONTENT_BLACKLIST(AwForbiddenException.class, "The file has a prohibited extension"),
    NOT_FOUND(AwNotFoundException.class, "The item was not found"),
    ENTRY_VERSION_MISMATCH(AwEntryVersionMismatchException.class, "The entry was modified by another user and is therefore not up to date; please retry the operation"),
    RETRYABLE_ERROR(AwRetryableException.class, "An unexpected error occurred; please retry the operation"),
    DOWNLOAD_CLIENT_DURING_UPGRADE(AwRetryableException.class, "Downloading client binary is not allowed during upgrade"),
    VIRUS_FOUND("A virus was detected"),
    BAD_GATEWAY,
    ENTRY_EXISTS(AwConflictException.class, "An entry already exists at the given path"),
    OWNER_FILES_QUOTA(AwEntryLimitExceededException.class, "The folder owner's file limit has been reached"),
    USER_FILES_QUOTA(AwEntryLimitExceededException.class, "Your file limit has been reached"),
    USER_DIRECTORIES_QUOTA(AwEntryLimitExceededException.class, "You have reached the maximum number of directories you are allowed to have"),
    DIRECTORY_ENTRIES_QUOTA_EXCEEDED(AwEntryLimitExceededException.class, "The directory is full"),
    OWNER_STORAGE_QUOTA(AwOverStorageQuotaException.class, "The folder owner's storage quota has been reached"),
    USER_STORAGE_QUOTA(AwOverStorageQuotaException.class, "Your storage quota has been reached"),
    USER_DIRECTORY_DEPTH_LIMIT_EXCEEDED(AwEntryLimitExceededException.class, "You have reached the maximum number of subdirectories you are allowed to have"),
    PATH_LENGTH_EXCEEDED(AwInvalidPathException.class, "The path is too long"),
    FILE_LENGTH_EXCEEDED(AwFileNameLengthExceededException.class, "The file name is too long"),
    FILE_SIZE_EXCEEDED(AwFileTooLargeException.class, "The file size is too large"),
    TYPE_COLLISION(AwConflictException.class, "An entry of a different type already exists at the path"),
    FILE_IN_USE(AwConflictException.class, "The file is in use"),
    FILE_IS_LOCKED(AwConflictException.class, "The file is locked by Microsoft Office for the web"),
    DIRECTORY_NAME_CONFLICT(AwConflictException.class, "A conflicting directory already exists"),
    FEATURE_NOT_ENABLED(AwForbiddenException.class, "The feature is not enabled"),
    SOCKET_TIMEOUT(AwRetryableException.class, "The operation timed out"),
    IO_EXCEPTION(AwRetryableException.class),
    SIZE_MISMATCH(AwInvalidRequestException.class),
    HASH_MISMATCH(AwInvalidRequestException.class),
    VERSION_MISMATCH(AwEntryVersionMismatchException.class),
    UNAUTHORIZED_REQUEST("Unauthorized request"),
    DIRECTORY_ALREADY_SHARED(AwInvalidRequestException.class, "Directory already shared"),
    DUPLICATE_LABEL(AwInvalidRequestException.class, "The label is already used"),
    INVALID_COPY(AwInvalidRequestException.class, "Cannot copy a folder into itself or one of its subfolders."),
    INVALID_LABEL(AwInvalidRequestException.class, "The label is invalid"),
    CHILD_SHARE_EXISTS(AwInvalidRequestException.class, "You are not allowed to create a share containing a child share"),
    EDP_CHILD_SHARE_EXISTS(AwInvalidRequestException.class, "You are not allowed to create a share containing a backup folder"),
    MOBILIZED_SHARE_EXISTS(AwInvalidRequestException.class, "You are not allowed to create a share containing a mobilized share"),
    DIRECTORY_NOT_SHARED(AwInvalidRequestException.class, "The directory is not shared"),
    INTERNAL_SERVER_ERROR(AwRetryableException.class, "An unexpected error occurred"),
    INVALID_CLIENT,
    INVALID_USER,
    INVALID_EMAIL("The provided email address is invalid"),
    EMAIL_CHANGE_NOT_ALLOWED(AwForbiddenException.class, "You are not allowed to change your email, please dismiss email field in your request"),
    LINK_DISABLED(AwForbiddenException.class, "The link is disabled due to system configuration or owner's profile settings"),
    LINK_READ_NOT_ALLOWED(AwForbiddenException.class, "The link doesn't grant read permission"),
    LINK_WRITE_NOT_ALLOWED(AwForbiddenException.class, "The link doesn't grant write permission"),
    INVALID_ACCESS_CODE(AwForbiddenException.class, "The provided access code or link cookie is invalid"),
    QUOTA_ERROR(AwOverStorageQuotaException.class, ""),
    USER_CLIENT_QUOTA(AwLimitExceededException.class, ""),
    BAD_PARAMETER(AwInvalidRequestException.class, ""),
    PARAMETER_REQUIRED(AwInvalidRequestException.class, ""),
    RSYNC_BASIS_VERSION_NOT_FOUND(""),
    CLIENT_NOT_FOUND(""),
    CONFLICT(AwConflictException.class, "A conflict occurred"),
    RSYNC_ERROR,
    RSYNC_DISABLED,
    RSYNC_BUSY,
    RSYNC_NOT_ALLOWED,
    SHARING_NOT_ENABLED("Link sharing is not enabled"),
    UPLOAD_SHARING_NOT_ENABLED("Upload link sharing is not enabled"),
    STORAGE_QUOTA(AwOverStorageQuotaException.class, ""),
    PUBLIC_SHARING_DISABLED("Public link sharing is not enabled"),
    PUBLIC_UPLOAD_SHARING_DISABLED("Public link sharing is not enabled"),
    SHARING_LIFETIME_INVALID(AwInvalidRequestException.class, "The length of time to share the link is invalid"),
    USER_LIMIT_EXCEEDED(AwLimitExceededException.class, "The maximum number of users has been reached"),
    OPTIMISTIC_CREATE_FAILED,
    CHUNKED_CREATE_FAILED,
    CLIENT_TOO_OLD,
    CLIENT_TOO_NEW,
    PATH_NOT_SHARE,
    CLIENT_NOT_ALLOWED("The specified client is not allowed."),
    NON_SYNCING_SHARE,
    PERMISSION_DENIED("Permission denied"),
    TEAM_FOLDER_SIZE_EXCEEDS_QUOTA("The team folder's size is too large for the requested quota."),
    TEAM_FOLDER_STORAGE_POOL_CAPACITY_EXCEEDED("Team folder storage pool capacity exceeded."),
    SHARE_WHITELISTING_ERROR("This operation is against owner's share whitelisting settings."),
    TOO_MANY_RESULTS("Too many results"),
    REMOVE_LAST_MANAGER(AwRemoveLastManagerException.class, "The operation was unsuccessful because it would remove the last manager of the share."),
    OWNED_SHARES_LIMIT_EXCEEDED(AwOwnedSharesLimitExceeded.class, "Your owned shared folders limit has been reached."),
    JOINED_SHARES_LIMIT_EXCEEDED(AwJoinedSharesLimitExceeded.class, "Your joined shared folders limit has been reached."),
    REMOVE_OWNER_FROM_SHARE(AwRemoveOwnerFromShareException.class, "The operation was unsuccessful because it would remove the owner of a shared folder."),
    GROUP_RESTRICTED("The group you attempted to add is restricted"),
    CSRF_TOKEN_CHECK_FAILED("The CSRF token check failed. Cannot perform requested action"),
    ADDITIONAL_AUTHENTICATION_NEEDED("Additional authentication needed."),
    INVALID_RENAME_DESTINATION(AwInvalidRequestException.class, "Invalid rename destination."),
    TEAM_FOLDER_STORAGE_QUOTA(AwOverStorageQuotaException.class, "The team folder's quota has been reached."),
    ACCESS_CODE_REQUIRED(AwInvalidRequestException.class, "Must create link with an access code"),
    QUERY_CANCELED_ERROR(AwQueryCanceledException.class, "The operation timed out or was canceled.");

    private final Class<? extends AnywhereHttpException> errorClass;
    private final String defaultErrorMsg;

    private FssApiError() {
        this(null, null);
    }

    private FssApiError(String defaultErrorMsg) {
        this(null, defaultErrorMsg);
    }

    private FssApiError(Class<? extends AnywhereHttpException> errorClass) {
        this(errorClass, null);
    }

    private FssApiError(Class<? extends AnywhereHttpException> errorClass, String defaultErrorMsg) {
        this.errorClass = errorClass;
        this.defaultErrorMsg = defaultErrorMsg;
    }

    Class<? extends AnywhereHttpException> getErrorClass() {
        return this.errorClass;
    }

    Class<? extends AnywhereHttpException> getErrorClass(int statusCode) {
        return this.errorClass != null ? this.errorClass : AnywhereExceptionFactory.getErrorClass(statusCode);
    }

    public String getError() {
        return this.name();
    }

    public String getDefaultErrorMsg() {
        return this.defaultErrorMsg;
    }
}

