/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class AccountSettings
extends BaseFssApiResource {
    @Schema(description="Whether email notification are enabled or not")
    private Boolean emailEnabled;
    @Schema(description="The email Quota")
    private Boolean emailQuota;
    @Schema(description="The email devices")
    private Boolean emailDevices;
    @Schema(description="The email authentication")
    private Boolean emailAuth;
    @Schema(description="The email share file")
    private Boolean emailShareFile;
    @Schema(description="The email upload")
    private Boolean emailUpload;
    @Schema(description="The email share folder")
    private Boolean emailShareFolder;
    @Schema(description="The user's allowed clients")
    private List<String> allowedClients;
    @Schema(description="The language")
    private String language;
    @Schema(description="Whether or not the user has FSS enabled")
    private Boolean fssEnabled;
    @Schema(description="Whether or not open Office files on mouse click")
    private Boolean openFilesOnClick;
    @Schema(description="Whether or not open single click guide box")
    private Boolean showSingleClickUserGuide;

    public static Class<? extends AccountSettings> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return V440.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static AccountSettings create(FssApiVersion apiVersion, Boolean emailEnabled, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, List<String> allowedClients, Boolean fssEnabled, Boolean openFilesOnClick, Boolean showSingleClickUserGuide) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(apiVersion, emailEnabled, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, allowedClients, fssEnabled, openFilesOnClick, showSingleClickUserGuide);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_303)) {
            return new V303(apiVersion, emailEnabled, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, allowedClients, fssEnabled);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, emailEnabled, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, allowedClients);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private AccountSettings() {
    }

    private AccountSettings(Boolean emailEnabled, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, List<String> allowedClients, Boolean fssEnabled, Boolean openFilesOnClick, Boolean showSingleClickUserGuide) {
        this.emailEnabled = emailEnabled;
        this.emailQuota = emailQuota;
        this.emailDevices = emailDevices;
        this.emailAuth = emailAuth;
        this.emailShareFile = emailShareFile;
        this.emailUpload = emailUpload;
        this.emailShareFolder = emailShareFolder;
        this.language = language;
        this.allowedClients = allowedClients;
        this.fssEnabled = fssEnabled;
        this.openFilesOnClick = openFilesOnClick;
        this.showSingleClickUserGuide = showSingleClickUserGuide;
    }

    public Boolean getEmailedEnabled() {
        return this.emailEnabled;
    }

    public Boolean getEmailQuota() {
        return this.emailQuota;
    }

    public Boolean getEmailDevices() {
        return this.emailDevices;
    }

    public Boolean getEmailAuth() {
        return this.emailAuth;
    }

    public Boolean getEmailShareFile() {
        return this.emailShareFile;
    }

    public Boolean getEmailUpload() {
        return this.emailUpload;
    }

    public Boolean getEmailShareFolder() {
        return this.emailShareFolder;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<String> getAllowedClients() {
        return this.allowedClients;
    }

    public Boolean getFssEnabled() {
        return this.fssEnabled;
    }

    public Boolean getOpenFilesOnClick() {
        return this.openFilesOnClick;
    }

    public Boolean isShowSingleClickUserGuide() {
        return this.showSingleClickUserGuide;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends AccountSettings {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Boolean emailEnabled, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, List<String> allowedClients) {
            super(emailEnabled, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, allowedClients, null, false, false);
        }
    }

    private static class V303
    extends AccountSettings {
        private V303() {
        }

        private V303(FssApiVersion apiVersion, Boolean emailEnabled, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, List<String> allowedClients, Boolean fssEnabled) {
            super(emailEnabled, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, allowedClients, fssEnabled, false, false);
        }
    }

    private static class V440
    extends AccountSettings {
        private V440() {
        }

        private V440(FssApiVersion apiVersion, Boolean emailEnabled, Boolean emailQuota, Boolean emailDevices, Boolean emailAuth, Boolean emailShareFile, Boolean emailUpload, Boolean emailShareFolder, String language, List<String> allowedClients, Boolean fssEnabled, Boolean openFilesOnClick, Boolean showSingleClickUserGuide) {
            super(emailEnabled, emailQuota, emailDevices, emailAuth, emailShareFile, emailUpload, emailShareFolder, language, allowedClients, fssEnabled, openFilesOnClick, showSingleClickUserGuide);
        }
    }
}

