/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthConfigFactor;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class AuthConfig
extends BaseFssApiResource {
    private String name;
    private Long priority;
    List<AuthConfigFactor> factors;

    public static Class<? extends AuthConfig> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_410)) {
            return V410.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static AuthConfig create(FssApiVersion apiVersion, String name, Long priority, List<AuthConfigFactor> factors) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_410)) {
            return new V410(apiVersion, name, priority, factors);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private AuthConfig(String name, Long priority, List<AuthConfigFactor> factors) {
        this.name = name;
        this.priority = priority;
        this.factors = factors;
    }

    private AuthConfig() {
    }

    public String getName() {
        return this.name;
    }

    public Long getPriority() {
        return this.priority;
    }

    @Schema(name="factors", description="The list of authentication configuration", required=true)
    public List<AuthConfigFactor> getAuthConfigFactors() {
        return this.factors;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V410
    extends AuthConfig {
        private V410() {
        }

        private V410(FssApiVersion apiVersion, String name, Long priority, List<AuthConfigFactor> factors) {
            super(name, priority, factors);
        }
    }
}

