/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.AuthConfigFactorType;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.ProviderType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;

public class AuthConfigFactor
extends BaseFssApiResource {
    private String id;
    private String providerId;
    private ProviderType providerType;
    private String name;
    private AuthConfigFactorType type;
    private Long priority;

    public static Class<? extends AuthConfigFactor> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_410)) {
            return V410.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static AuthConfigFactor create(FssApiVersion apiVersion, String id, String providerId, ProviderType providerType, String name, AuthConfigFactorType type, Long priority) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_410)) {
            return new V410(apiVersion, id, providerId, providerType, name, type, priority);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private AuthConfigFactor(String id, String providerId, ProviderType providerType, String name, AuthConfigFactorType type, Long priority) {
        this.id = id;
        this.providerId = providerId;
        this.providerType = providerType;
        this.name = name;
        this.type = type;
        this.priority = priority;
    }

    private AuthConfigFactor() {
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public ProviderType getProviderType() {
        return this.providerType;
    }

    public String getName() {
        return this.name;
    }

    public AuthConfigFactorType getType() {
        return this.type;
    }

    public Long getPriority() {
        return this.priority;
    }

    public boolean isActiveDirectory() {
        return this.providerType.equals((Object)ProviderType.ACTIVE_DIRECTORY);
    }

    public boolean isSAML() {
        return this.providerType.equals((Object)ProviderType.SAML);
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V410
    extends AuthConfigFactor {
        private V410() {
        }

        private V410(FssApiVersion apiVersion, String id, String providerId, ProviderType providerType, String name, AuthConfigFactorType type, Long priority) {
            super(id, providerId, providerType, name, type, priority);
        }
    }
}

