/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Splitter;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class AuthToken {
    @Schema(description="Access token identifying user and login credentials")
    @SerializedName(value="access_token")
    private final String token;
    @Schema(description="Type of token")
    @SerializedName(value="token_type")
    private final String type;

    private AuthToken(String type, String token) {
        this.token = token;
        this.type = type;
    }

    public static AuthToken fromString(String tokenString) {
        List parts = Splitter.on((String)" ").limit(2).splitToList((CharSequence)tokenString);
        if (parts.size() != 2) {
            throw new IllegalArgumentException();
        }
        return new AuthToken((String)parts.get(0), (String)parts.get(1));
    }

    public String toString() {
        return AuthToken.toAuthHeaderValue(this.type, this.token);
    }

    public static String toAuthHeaderValue(String type, String value) {
        return String.format("%s %s", type, value);
    }
}

