/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;

public abstract class Authentication
extends BaseFssApiResource {
    public static Class<? extends Authentication> getPublicApiClass(FssApiVersion fssApiVersion) {
        if (fssApiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_450)) {
            return V450.class;
        }
        if (fssApiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_432)) {
            return V432.class;
        }
        throw new UnsupportedOperationException("Unsupported Public API version: " + fssApiVersion);
    }

    public static Authentication create(FssApiVersion apiVersion, String username, String password, String grantType) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_450)) {
            return new V450(username, password, grantType, "PUBLIC_API");
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_432)) {
            return new V432(username, password, grantType);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private static class V450
    extends V432 {
        private String clientType;

        private V450() {
        }

        protected V450(String username, String password, String grantType, String clientType) {
            super(username, password, grantType);
            this.clientType = clientType;
        }

        @Override
        protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
            super.validate(fieldName, parent);
            this.validateFieldNotNull("clientType", this.clientType, fieldName);
        }

        public String getClientType() {
            return this.clientType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            V450 other = (V450)o;
            return Objects.equal((Object)this.getUsername(), (Object)other.getUsername()) && Objects.equal((Object)this.getPassword(), (Object)other.getPassword()) && Objects.equal((Object)this.getGrantType(), (Object)other.getGrantType()) && Objects.equal((Object)this.getClientType(), (Object)other.clientType);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getUsername(), this.getPassword(), this.getGrantType(), this.getClientType()});
        }
    }

    private static class V432
    extends Authentication {
        private String username;
        private String password;
        @SerializedName(value="grant_type")
        private String grantType;

        private V432() {
        }

        protected V432(String username, String password, String grantType) {
            this.username = username;
            this.password = password;
            this.grantType = grantType;
        }

        @Override
        protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
            this.validateFieldNotNull("username", this.username, fieldName);
            this.validateFieldNotNull("password", this.password, fieldName);
            this.validateFieldNotNull("grant_type", this.grantType, fieldName);
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getGrantType() {
            return this.grantType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            V432 other = (V432)o;
            return Objects.equal((Object)this.username, (Object)other.username) && Objects.equal((Object)this.password, (Object)other.password) && Objects.equal((Object)this.grantType, (Object)other.grantType);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.username, this.password, this.grantType});
        }
    }
}

