/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.gson.stream.JsonWriter;
import com.hds.commons.exception.InvalidInputException;
import com.hds.commons.json.JsonWritable;
import com.hds.commons.util.GsonHelper;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.model.FssApiConstants;
import com.hds.hcpaw.fss.api.version.FssApiGsonHelper;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;

@JsonWritable
public abstract class BaseFssApiResource {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static void writeToOutputStream(Object o, OutputStream outputStream) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(outputStream, UTF_8);
        JsonWriter jsw = new JsonWriter((Writer)w);
        FssApiGsonHelper.toJson(o, o.getClass(), jsw);
        jsw.close();
    }

    public static String toJson(Object o) {
        return GsonHelper.toJson(o, o.getClass());
    }

    public String toJson() {
        return GsonHelper.toJson((Object)this, this.getClass());
    }

    public static <T extends BaseFssApiResource> T fromJson(FssApiVersion version, Reader reader, Class<T> type) throws AwJsonException {
        try {
            BaseFssApiResource ret = (BaseFssApiResource)FssApiGsonHelper.fromJson(version, reader, type);
            if (ret == null) {
                throw new AwJsonException("Missing request body");
            }
            ret.validate();
            return (T)ret;
        }
        catch (InvalidInputException e) {
            throw new AwJsonException(e);
        }
    }

    public void validate() throws AwJsonException {
        this.validate(null, null);
    }

    protected abstract void validate(String var1, BaseFssApiResource var2) throws AwJsonException;

    protected void validateRequiredField(String fieldName, BaseFssApiResource fieldValue, String parentFieldName) throws AwJsonException {
        this.validateFieldNotNull(fieldName, fieldValue, parentFieldName);
        this.validateOptionalField(fieldName, fieldValue);
    }

    protected void validateOptionalField(String fieldName, BaseFssApiResource fieldValue) throws AwJsonException {
        if (fieldValue != null) {
            fieldValue.validate(fieldName, this);
        }
    }

    protected <T> void validateRequiredFieldList(String fieldName, List<T> fieldValues, String parentFieldName) throws AwJsonException {
        this.validateFieldNotNull(fieldName, fieldValues, parentFieldName);
        this.validateOptionalFieldList(fieldName, fieldValues, parentFieldName);
    }

    protected <T> void validateOptionalFieldList(String fieldName, List<T> fieldValues, String parentFieldName) throws AwJsonException {
        if (fieldValues != null) {
            int i = 0;
            for (T fieldValue : fieldValues) {
                String valueName = fieldName + "[" + i + "]";
                this.validateFieldNotNull(valueName, fieldValue, parentFieldName);
                if (fieldValue instanceof BaseFssApiResource) {
                    this.validateOptionalField(valueName, (BaseFssApiResource)fieldValue);
                }
                ++i;
            }
        }
    }

    protected void validateFieldNotNull(String fieldName, Object fieldValue, String parentFieldName) throws AwJsonException {
        if (fieldValue == null) {
            throw new AwJsonException("Missing or invalid field '" + fieldName + "'" + (parentFieldName == null ? "" : " in field '" + parentFieldName + "'"));
        }
    }

    protected void validateFieldInRange(String fieldName, Long fieldValue, long min, long max, String parentFieldName) throws AwJsonException {
        if (fieldValue == null || fieldValue < min || fieldValue > max) {
            throw new AwJsonException("Field '" + fieldName + "' is not in range " + min + " to " + max + (parentFieldName == null ? "" : " in field '") + parentFieldName + "'");
        }
    }

    protected void validateFieldInRange(String fieldName, Integer fieldValue, int min, int max, String parentFieldName) throws AwJsonException {
        if (fieldValue == null || fieldValue < min || fieldValue > max) {
            throw new AwJsonException("Field '" + fieldName + "' is not in range " + min + " to " + max + (parentFieldName == null ? "" : " in field '") + parentFieldName + "'");
        }
    }

    protected void validateFieldIsNull(String fieldName, Object fieldValue, String parentFieldName) throws AwJsonException {
        if (fieldValue != null) {
            throw new AwJsonException("Field '" + fieldName + "'" + (parentFieldName == null ? "" : " in field '" + parentFieldName + "'") + " is not allowed here.");
        }
    }

    protected void validateLocale(String fieldName, String fieldValue, String parentFieldName) throws AwJsonException {
        if (fieldValue.equals("browser")) {
            return;
        }
        if (FssApiConstants.SUPPORTED_LOCALE_LIST.contains(Locale.forLanguageTag(fieldValue))) {
            return;
        }
        throw new AwJsonException("Locale represented by field '" + fieldName + "'" + (parentFieldName == null ? "" : " in field '" + parentFieldName + "'") + " is not supported.");
    }

    protected void badValue(String fieldName, String parentFieldName) throws AwJsonException {
        this.badValue(fieldName, parentFieldName, null);
    }

    protected void badValue(String fieldName, String parentFieldName, String reason) throws AwJsonException {
        throw new AwJsonException("The value for field '" + fieldName + "'" + (parentFieldName == null ? "" : " in field '" + parentFieldName + "'") + " is invalid.  " + (reason == null ? "" : reason));
    }

    public String toString() {
        return GsonHelper.toPrettyJson(this);
    }
}

