/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.awt.Dimension;

public class BrandingInfo
extends BaseFssApiResource {
    @Schema(description="The product name set for branding")
    private String productName;
    @Schema(description="Whether or not the product name is branded")
    private Boolean productNameBranded;
    @Schema(description="The product description set for branding")
    private String description;
    @Schema(description="The powered by name set for branding")
    private String poweredByName;
    @Schema(description="The name displayed for the app in Microsoft Teams")
    private String msTeamsAppName;
    @Schema(description="The login help message link text set for branding")
    private String loginHelpMessageLink;
    @Schema(description="Whether or not the logo image is branded")
    private Boolean logoImageBranded;
    @Schema(description="The path of the logo image, if it is branded")
    private String logoImageBrandedPath;
    @Schema(description="Whether or not the powered by image is branded")
    private Boolean poweredByImageBranded;
    @Schema(description="The path of the powered by image, if it is branded")
    private String poweredByImageBrandedPath;
    @Schema(description="Whether or not the favicon image is branded")
    private Boolean faviconImageBranded;
    @Schema(description="The path of the favicon image, if it is branded")
    private String faviconImageBrandedPath;
    @Schema(description="Whether or not the EULA html is branded")
    private Boolean eulaHtmlBranded;
    @Schema(description="The path of the EULA html, if it is branded")
    private String eulaHtmlBrandedPath;
    @Schema(description="Whether or not the login help HTML is branded")
    private Boolean loginHelpHtmlBranded;
    @Schema(description="The path of the login help HTML, if it is branded")
    private String loginHelpHtmlBrandedPath;
    @Schema(description="Whether or not network login is enabled")
    private Boolean networkLoginEnabled;
    @Schema(description="The path of the login logo image, if it is branded")
    private String loginLogoImageBrandedPath;
    @Schema(description="Whether or not the login logo image for HCPAW is branded")
    private Boolean loginLogoImageBranded;
    @Schema(name="showProductName", description="Whether the product name is shown")
    private Boolean showProductName;
    @Schema(description="The dimensions of the product logo")
    private Dimension logoDimension;
    @Schema(description="The dimensions of the login logo")
    private Dimension loginLogoDimension;
    @Schema(description="The dimensions of powered by logo")
    private Dimension poweredByLogoDimension;
    @Schema(description="The dimensions of the tab logo (favicon)")
    private Dimension tabLogoDimension;

    public static Class<? extends BrandingInfo> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_310)) {
            return V310.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static BrandingInfo create(FssApiVersion apiVersion, String productName, Boolean productNameBranded, String description, String poweredByName, String msTeamsAppName, String loginHelpMessageLink, Boolean logoImageBranded, String logoImageBrandedPath, Boolean poweredByImageBranded, String poweredByImageBrandedPath, Boolean faviconImageBranded, String faviconImageBrandedPath, Boolean eulaHtmlBranded, String eulaHtmlBrandedPath, Boolean loginHelpHtmlBranded, String loginHelpHtmlBrandedPath, Boolean networkLoginEnabled, String loginLogoImageBrandedPath, Boolean loginLogoImageBranded, Boolean showProductName, Dimension logoDimension, Dimension loginLogoDimension, Dimension poweredByLogoDimension, Dimension tabLogoDimension) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_450)) {
            return new V450(apiVersion, productName, productNameBranded, description, poweredByName, msTeamsAppName, loginHelpMessageLink, logoImageBranded, logoImageBrandedPath, poweredByImageBranded, poweredByImageBrandedPath, faviconImageBranded, faviconImageBrandedPath, eulaHtmlBranded, eulaHtmlBrandedPath, loginHelpHtmlBranded, loginHelpHtmlBrandedPath, networkLoginEnabled, loginLogoImageBrandedPath, loginLogoImageBranded, showProductName, logoDimension, loginLogoDimension, poweredByLogoDimension, tabLogoDimension);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_310)) {
            return new V310(apiVersion, productName, productNameBranded, description, poweredByName, loginHelpMessageLink, logoImageBranded, logoImageBrandedPath, poweredByImageBranded, poweredByImageBrandedPath, faviconImageBranded, faviconImageBrandedPath, eulaHtmlBranded, eulaHtmlBrandedPath, loginHelpHtmlBranded, loginHelpHtmlBrandedPath, networkLoginEnabled, loginLogoImageBrandedPath, loginLogoImageBranded, showProductName, logoDimension, loginLogoDimension, poweredByLogoDimension, tabLogoDimension);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, productName, description, poweredByName, loginHelpMessageLink, logoImageBranded, logoImageBrandedPath, poweredByImageBranded, poweredByImageBrandedPath, faviconImageBranded, faviconImageBrandedPath, eulaHtmlBranded, eulaHtmlBrandedPath, loginHelpHtmlBranded, loginHelpHtmlBrandedPath, networkLoginEnabled);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private BrandingInfo() {
    }

    private BrandingInfo(String productName, Boolean productNameBranded, String description, String poweredByName, String msTeamsAppName, String loginHelpMessageLink, Boolean logoImageBranded, String logoImageBrandedPath, Boolean poweredByImageBranded, String poweredByImageBrandedPath, Boolean faviconImageBranded, String faviconImageBrandedPath, Boolean eulaHtmlBranded, String eulaHtmlBrandedPath, Boolean loginHelpHtmlBranded, String loginHelpHtmlBrandedPath, Boolean networkLoginEnabled, String loginLogoImageBrandedPath, Boolean loginLogoImageBranded, Boolean showProductName, Dimension logoDimension, Dimension loginLogoDimension, Dimension poweredByLogoDimension, Dimension tabLogoDimension) {
        this.productName = productName;
        this.productNameBranded = productNameBranded;
        this.description = description;
        this.poweredByName = poweredByName;
        this.msTeamsAppName = msTeamsAppName;
        this.loginHelpMessageLink = loginHelpMessageLink;
        this.logoImageBranded = logoImageBranded;
        this.logoImageBrandedPath = logoImageBrandedPath;
        this.poweredByImageBranded = poweredByImageBranded;
        this.poweredByImageBrandedPath = poweredByImageBrandedPath;
        this.faviconImageBranded = faviconImageBranded;
        this.faviconImageBrandedPath = faviconImageBrandedPath;
        this.eulaHtmlBranded = eulaHtmlBranded;
        this.eulaHtmlBrandedPath = eulaHtmlBrandedPath;
        this.loginHelpHtmlBranded = loginHelpHtmlBranded;
        this.networkLoginEnabled = networkLoginEnabled;
        this.loginHelpHtmlBrandedPath = loginHelpHtmlBrandedPath;
        this.loginLogoImageBrandedPath = loginLogoImageBrandedPath;
        this.loginLogoImageBranded = loginLogoImageBranded;
        this.showProductName = showProductName;
        this.logoDimension = logoDimension;
        this.loginLogoDimension = loginLogoDimension;
        this.poweredByLogoDimension = poweredByLogoDimension;
        this.tabLogoDimension = tabLogoDimension;
    }

    public String getProductName() {
        return this.productName;
    }

    public Boolean getProductNameBranded() {
        return this.productNameBranded;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPoweredByName() {
        return this.poweredByName;
    }

    public String getMSTeamsAppName() {
        return this.msTeamsAppName;
    }

    public String getLoginHelpMessageLink() {
        return this.loginHelpMessageLink;
    }

    public Boolean isLogoImageBranded() {
        return this.logoImageBranded;
    }

    public Boolean isPoweredByImageBranded() {
        return this.poweredByImageBranded;
    }

    public Boolean isFaviconImageBranded() {
        return this.faviconImageBranded;
    }

    public Boolean isEulaHtmlBranded() {
        return this.eulaHtmlBranded;
    }

    public Boolean isLoginHelpHtmlBranded() {
        return this.loginHelpHtmlBranded;
    }

    public Boolean isNetworkLoginEnabled() {
        return this.networkLoginEnabled;
    }

    public String getLogoImageBrandedPath() {
        return this.logoImageBrandedPath;
    }

    public String getPoweredByImageBrandedPath() {
        return this.poweredByImageBrandedPath;
    }

    public String getFaviconImageBrandedPath() {
        return this.faviconImageBrandedPath;
    }

    public String getEulaHtmlBrandedPath() {
        return this.eulaHtmlBrandedPath;
    }

    public String getLoginHelpHtmlBrandedPath() {
        return this.loginHelpHtmlBrandedPath;
    }

    public String getLoginLogoImageBrandedPath() {
        return this.loginLogoImageBrandedPath;
    }

    public Boolean getLoginLogoImageBranded() {
        return this.loginLogoImageBranded;
    }

    @Schema(name="showProductName", description="Whether the product name is shown")
    public Boolean isProductNameShown() {
        return this.showProductName;
    }

    public Dimension getLogoDimension() {
        return this.logoDimension;
    }

    public Dimension getLoginLogoDimension() {
        return this.loginLogoDimension;
    }

    public Dimension getPoweredByLogoDimension() {
        return this.poweredByLogoDimension;
    }

    public Dimension getTabLogoDimension() {
        return this.tabLogoDimension;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BrandingInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        BrandingInfo e = (BrandingInfo)o;
        return Objects.equal((Object)this.getProductName(), (Object)e.getProductName()) && Objects.equal((Object)this.getDescription(), (Object)e.getDescription()) && Objects.equal((Object)this.getPoweredByName(), (Object)e.getPoweredByName()) && Objects.equal((Object)this.getMSTeamsAppName(), (Object)e.getMSTeamsAppName()) && Objects.equal((Object)this.getLoginHelpMessageLink(), (Object)e.getLoginHelpMessageLink()) && Objects.equal((Object)this.isLogoImageBranded(), (Object)e.isLogoImageBranded()) && Objects.equal((Object)this.getLogoImageBrandedPath(), (Object)e.getLogoImageBrandedPath()) && Objects.equal((Object)this.isPoweredByImageBranded(), (Object)e.isPoweredByImageBranded()) && Objects.equal((Object)this.getPoweredByImageBrandedPath(), (Object)e.getPoweredByImageBrandedPath()) && Objects.equal((Object)this.isFaviconImageBranded(), (Object)e.isFaviconImageBranded()) && Objects.equal((Object)this.getFaviconImageBrandedPath(), (Object)e.getFaviconImageBrandedPath()) && Objects.equal((Object)this.isEulaHtmlBranded(), (Object)e.isEulaHtmlBranded()) && Objects.equal((Object)this.getEulaHtmlBrandedPath(), (Object)e.getEulaHtmlBrandedPath()) && Objects.equal((Object)this.isLoginHelpHtmlBranded(), (Object)e.isLoginHelpHtmlBranded()) && Objects.equal((Object)this.isNetworkLoginEnabled(), (Object)e.isNetworkLoginEnabled()) && Objects.equal((Object)this.getLoginHelpHtmlBrandedPath(), (Object)e.getLoginHelpHtmlBrandedPath()) && Objects.equal((Object)this.getLoginLogoImageBrandedPath(), (Object)e.getLoginLogoImageBrandedPath()) && Objects.equal((Object)this.isProductNameShown(), (Object)e.isProductNameShown()) && Objects.equal((Object)this.getLogoDimension(), (Object)e.getLogoDimension()) && Objects.equal((Object)this.getLoginLogoDimension(), (Object)e.getLoginLogoDimension()) && Objects.equal((Object)this.getPoweredByLogoDimension(), (Object)e.getPoweredByLogoDimension()) && Objects.equal((Object)this.getTabLogoDimension(), (Object)e.getTabLogoDimension()) && Objects.equal((Object)this.getLoginLogoImageBranded(), (Object)e.getLoginLogoImageBranded());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getDescription(), this.getProductName(), this.getPoweredByName(), this.getMSTeamsAppName(), this.getLoginHelpMessageLink(), this.isLogoImageBranded(), this.getLogoImageBrandedPath(), this.isPoweredByImageBranded(), this.getPoweredByImageBrandedPath(), this.isFaviconImageBranded(), this.getFaviconImageBrandedPath(), this.isEulaHtmlBranded(), this.getEulaHtmlBrandedPath(), this.isLoginHelpHtmlBranded(), this.getLoginHelpHtmlBrandedPath(), this.isNetworkLoginEnabled(), this.getLoginLogoImageBrandedPath(), this.isProductNameShown(), this.getLogoDimension(), this.getLoginLogoDimension(), this.getPoweredByLogoDimension(), this.getTabLogoDimension(), this.getLoginLogoImageBranded()});
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V450
    extends BrandingInfo {
        private V450() {
        }

        private V450(FssApiVersion apiVersion, String productName, Boolean productNameBranded, String description, String poweredByName, String msTeamsAppName, String loginHelpMessageLink, Boolean logoImageBranded, String logoImageBrandedPath, Boolean poweredByImageBranded, String poweredByImageBrandedPath, Boolean faviconImageBranded, String faviconImageBrandedPath, Boolean eulaHtmlBranded, String eulaHtmlBrandedPath, Boolean loginHelpHtmlBranded, String loginHelpHtmlBrandedPath, Boolean networkLoginEnabled, String loginLogoImageBrandedPath, Boolean loginLogoImageBranded, Boolean showProductName, Dimension logoDimension, Dimension loginLogoDimension, Dimension poweredByLogoDimension, Dimension faviconDimension) {
            super(productName, productNameBranded, description, poweredByName, msTeamsAppName, loginHelpMessageLink, logoImageBranded, logoImageBrandedPath, poweredByImageBranded, poweredByImageBrandedPath, faviconImageBranded, faviconImageBrandedPath, eulaHtmlBranded, eulaHtmlBrandedPath, loginHelpHtmlBranded, loginHelpHtmlBrandedPath, networkLoginEnabled, loginLogoImageBrandedPath, loginLogoImageBranded, showProductName, logoDimension, loginLogoDimension, poweredByLogoDimension, faviconDimension);
        }
    }

    private static class V310
    extends BrandingInfo {
        private V310() {
        }

        private V310(FssApiVersion apiVersion, String productName, Boolean productNameBranded, String description, String poweredByName, String loginHelpMessageLink, Boolean logoImageBranded, String logoImageBrandedPath, Boolean poweredByImageBranded, String poweredByImageBrandedPath, Boolean faviconImageBranded, String faviconImageBrandedPath, Boolean eulaHtmlBranded, String eulaHtmlBrandedPath, Boolean loginHelpHtmlBranded, String loginHelpHtmlBrandedPath, Boolean networkLoginEnabled, String loginLogoImageBrandedPath, Boolean loginLogoImageBranded, Boolean showProductName, Dimension logoDimension, Dimension loginLogoDimension, Dimension poweredByLogoDimension, Dimension faviconDimension) {
            super(productName, productNameBranded, description, poweredByName, null, loginHelpMessageLink, logoImageBranded, logoImageBrandedPath, poweredByImageBranded, poweredByImageBrandedPath, faviconImageBranded, faviconImageBrandedPath, eulaHtmlBranded, eulaHtmlBrandedPath, loginHelpHtmlBranded, loginHelpHtmlBrandedPath, networkLoginEnabled, loginLogoImageBrandedPath, loginLogoImageBranded, showProductName, logoDimension, loginLogoDimension, poweredByLogoDimension, faviconDimension);
        }
    }

    private static class V300
    extends BrandingInfo {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String productName, String description, String poweredByName, String loginHelpMessageLink, Boolean logoImageBranded, String logoImageBrandedPath, Boolean poweredByImageBranded, String poweredByImageBrandedPath, Boolean faviconImageBranded, String faviconImageBrandedPath, Boolean eulaHtmlBranded, String eulaHtmlBrandedPath, Boolean loginHelpHtmlBranded, String loginHelpHtmlBrandedPath, Boolean networkLoginEnabled) {
            super(productName, null, description, poweredByName, null, loginHelpMessageLink, logoImageBranded, logoImageBrandedPath, poweredByImageBranded, poweredByImageBrandedPath, faviconImageBranded, faviconImageBrandedPath, eulaHtmlBranded, eulaHtmlBrandedPath, loginHelpHtmlBranded, loginHelpHtmlBrandedPath, networkLoginEnabled, null, null, null, null, null, null, null);
        }
    }
}

