/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ClearClientCredentialsRequest
extends BaseFssApiResource {
    @Schema(description="The unique string assigned to the application by HCP Anywhere", required=true)
    private String id;

    public static Class<? extends ClearClientCredentialsRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ClearClientCredentialsRequest create(FssApiVersion apiVersion, String id) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, id);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ClearClientCredentialsRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("id", this.id, fieldName);
    }

    private static class V300
    extends ClearClientCredentialsRequest {
        private V300(FssApiVersion apiVersion, String id) {
            super(id);
        }
    }
}

