/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class Client
extends BaseFssApiResource {
    @Schema(description="The unique string assigned to the application by HCP Anywhere", required=true)
    private String id;
    @Schema(description="The new name of the application", required=true)
    private String nickname;
    @Schema(description="The device type the HCP Anywhere application is installed on (ex. Windows or Mac or Microsoft Teams). For the User Portal, the os is always \"Browser\".", required=true)
    private String os;
    @Schema(description="The HCP Anywhere version of the application. For the User Portal and third-party applications, the version is always \"None\".", required=true)
    private String version;
    @Schema(description="The time which the application was last accessed by the user (returned in Unix format)", required=true)
    private Long lastAccess;
    @Schema(description="If true, an upgrade is available for the application. An upgrade becomes available when the HCP Anywhere system is upgraded.", required=true)
    private Boolean needsUpgrade;
    @Schema(description="If true, the application is in the middle of the recovery process. An application goes into the recovery process the first time it connects to the HCP Anywhere system after the HCP Anywhere system has been recovered.", required=true)
    private Boolean inRecovery;

    public static Class<? extends Client> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static Client create(FssApiVersion apiVersion, String id, String nickname, String os, String version, Long lastAccess, Boolean needsUpgrade, Boolean inRecovery) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, id, nickname, os, version, lastAccess, needsUpgrade, inRecovery);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private Client(String id, String nickname, String os, String version, Long lastAccess, Boolean needsUpgrade, Boolean inRecovery) {
        this.id = id;
        this.nickname = nickname;
        this.os = os;
        this.version = version;
        this.lastAccess = lastAccess;
        this.needsUpgrade = needsUpgrade;
        this.inRecovery = inRecovery;
    }

    private Client() {
    }

    public String getId() {
        return this.id;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getOs() {
        return this.os;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getLastAccess() {
        return this.lastAccess;
    }

    public Boolean getNeedsUpgrade() {
        return this.needsUpgrade;
    }

    public Boolean getInRecovery() {
        return this.inRecovery;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends Client {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String id, String nickname, String os, String version, Long lastAccess, Boolean needsUpgrade, Boolean inRecovery) {
            super(id, nickname, os, version, lastAccess, needsUpgrade, inRecovery);
        }
    }
}

