/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ClientDeregisterRequest
extends BaseFssApiResource {
    @Schema(description="The unique string assigned to the application by HCP Anywhere", required=true)
    private String id;
    @Schema(description="If true, HCP Anywhere registration information is removed from the device", required=true)
    private Boolean wipe;

    public static Class<? extends ClientDeregisterRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ClientDeregisterRequest create(FssApiVersion apiVersion, String id, Boolean wipe) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, id, wipe);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ClientDeregisterRequest(String id, Boolean wipe) {
        this.id = id;
        this.wipe = wipe;
    }

    public String getId() {
        return this.id;
    }

    public Boolean isWipe() {
        return this.wipe;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("id", this.id, fieldName);
        this.validateFieldNotNull("wipe", this.wipe, fieldName);
    }

    private static class V300
    extends ClientDeregisterRequest {
        private V300(FssApiVersion apiVersion, String id, Boolean wipe) {
            super(id, wipe);
        }
    }
}

