/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.PublicClientType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ClientDownloadRequest
extends BaseFssApiResource {
    @Schema(description="The application to download from the HCP Anywhere server", required=true)
    private PublicClientType client;

    public static Class<? extends ClientDownloadRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ClientDownloadRequest create(FssApiVersion apiVersion, PublicClientType client) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, client);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ClientDownloadRequest(PublicClientType client) {
        this.client = client;
    }

    public PublicClientType getClient() {
        return this.client;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("client", (Object)this.client, fieldName);
    }

    private static class V300
    extends ClientDownloadRequest {
        private V300(FssApiVersion apiVersion, PublicClientType client) {
            super(client);
        }
    }
}

