/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.Client;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class ClientListing
extends BaseFssApiResource {
    @Schema(description="The applications registered with the user's HCP Anywhere account", required=true)
    private List<Client> clients;

    public static Class<? extends ClientListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ClientListing create(FssApiVersion apiVersion, List<Client> clients) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(clients);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ClientListing(List<Client> clients) {
        this.clients = clients;
    }

    private ClientListing() {
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<Client> getClients() {
        return this.clients;
    }

    private static class V300
    extends ClientListing {
        private V300() {
        }

        private V300(List<Client> clients) {
            super(clients);
        }
    }
}

