/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ClientRenameRequest
extends BaseFssApiResource {
    @Schema(description="The unique string assigned to the application by HCP Anywhere", required=true)
    private String id;
    @Schema(description="The new name for the application", required=true)
    private String name;

    public static Class<? extends ClientRenameRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static ClientRenameRequest create(FssApiVersion apiVersion, String id, String name) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, id, name);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ClientRenameRequest(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("id", this.id, fieldName);
        this.validateFieldNotNull("name", this.name, fieldName);
    }

    private static class V300
    extends ClientRenameRequest {
        private V300(FssApiVersion apiVersion, String id, String name) {
            super(id, name);
        }
    }
}

