/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class CollaborationActivityEntry
extends BaseFssApiResource {
    @Schema(description="Describes the event", required=true)
    private String msg;
    @Schema(description="The time at which the event occurred (returned in Unix format)", required=true)
    private Long timestamp;
    @Schema(description="Nanoseconds associated with the timestamp", required=true)
    private transient Integer nanos;
    @Schema(description="The timestamp disambiguating short", required=true)
    private transient Short tsExtra;

    public static Class<? extends CollaborationActivityEntry> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static CollaborationActivityEntry create(FssApiVersion apiVersion, String msg, Long timestamp, Integer nanos, Short tsExtra) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, msg, timestamp, nanos, tsExtra);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private CollaborationActivityEntry() {
    }

    private CollaborationActivityEntry(String msg, Long timestamp, Integer nanos, Short tsExtra) {
        this.msg = msg;
        this.timestamp = timestamp;
        this.nanos = nanos;
        this.tsExtra = tsExtra;
    }

    public String getMsg() {
        return this.msg;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Integer getNanos() {
        return this.nanos;
    }

    public Short getTsExtra() {
        return this.tsExtra;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    private static class V300
    extends CollaborationActivityEntry {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, String msg, Long timestamp, Integer nanos, Short tsExtra) {
            super(msg, timestamp, nanos, tsExtra);
        }
    }
}

