/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class ConfigSettings
extends BaseFssApiResource {
    @Schema(description="The maximum size that a file can be when uploaded to HCP Anywhere")
    private Long maxFileUploadSize;
    @Schema(description="The URL where the HCP Anywhere iOS mobile application is located")
    private String iOSAppURL;
    @Schema(description="The URL where the HCP Anywhere android mobile application is located")
    private String androidAppURL;
    @Schema(description="The URL where the HCP Anywhere Windows Pone mobile application is located")
    private String windowsPhoneMobileAppLinkURL;
    @Schema(description="If true, the download link for the HCP Anywhere iOS mobile application is available on the HCP Anywhere website")
    private Boolean enableiOSDownloadLink;
    @Schema(description="If true, the download link for the HCP Anywhere android mobile application is available on the HCP Anywhere website")
    private Boolean enableAndroidDownloadLink;
    @Schema(description="If true, the download link for the HCP Anywhere Windows Phone mobile application is available on the HCP Anywhere website")
    private Boolean enableWindowsPhoneDownloadLink;
    @Schema(description="If true, the download link for the HCP Anywhere Windows desktop application is available on the HCP Anywhere website")
    private Boolean enableWindowsDownloadLink;
    @Schema(description="If true, the download link for the HCP Anywhere Mac desktop application is available on the HCP Anywhere website")
    private Boolean enableMacDownloadLink;
    @Schema(description="If true, the download link for the HCP Anywhere Outlook Add-in is available on the HCP Anywhere website")
    private Boolean enableOutlookDownloadLink;

    public static Class<? extends ConfigSettings> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ConfigSettings create(FssApiVersion apiVersion, Long maxFileUploadSize, String iOSAppURL, String androidAppURL, String windowsPhoneMobileAppLinkURL, Boolean enableiOSDownloadLink, Boolean enableAndroidDownloadLink, Boolean enableWindowsPhoneDownloadLink, Boolean enableWindowsDownloadLink, Boolean enableMacDownloadLink, Boolean enableOutlookDownloadLink) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(apiVersion, maxFileUploadSize, iOSAppURL, androidAppURL, windowsPhoneMobileAppLinkURL, enableiOSDownloadLink, enableAndroidDownloadLink, enableWindowsPhoneDownloadLink, enableWindowsDownloadLink, enableMacDownloadLink, enableOutlookDownloadLink);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ConfigSettings() {
    }

    private ConfigSettings(Long maxFileUploadSize, String iOSAppURL, String androidAppURL, String windowsPhoneMobileAppLinkURL, Boolean enableiOSDownloadLink, Boolean enableAndroidDownloadLink, Boolean enableWindowsPhoneDownloadLink, Boolean enableWindowsDownloadLink, Boolean enableMacDownloadLink, Boolean enableOutlookDownloadLink) {
        this.setMaxFileUploadSize(maxFileUploadSize);
        this.setiOSAppURL(iOSAppURL);
        this.setAndroidAppURL(androidAppURL);
        this.setWindowsPhoneMobileAppLinkURL(windowsPhoneMobileAppLinkURL);
        this.setEnableiOSDownloadLink(enableiOSDownloadLink);
        this.setEnableAndroidDownloadLink(enableAndroidDownloadLink);
        this.setEnableWindowsPhoneDownloadLink(enableWindowsPhoneDownloadLink);
        this.setEnableWindowsDownloadLink(enableWindowsDownloadLink);
        this.setEnableMacDownloadLink(enableMacDownloadLink);
        this.setEnableOutlookDownloadLink(enableOutlookDownloadLink);
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public Long getMaxFileUploadSize() {
        return this.maxFileUploadSize;
    }

    public void setMaxFileUploadSize(Long maxFileUploadSize) {
        this.maxFileUploadSize = maxFileUploadSize;
    }

    public String getiOSAppURL() {
        return this.iOSAppURL;
    }

    public void setiOSAppURL(String iOSAppURL) {
        this.iOSAppURL = iOSAppURL;
    }

    public String getAndroidAppURL() {
        return this.androidAppURL;
    }

    public void setAndroidAppURL(String androidAppURL) {
        this.androidAppURL = androidAppURL;
    }

    public String getWindowsPhoneMobileAppLinkURL() {
        return this.windowsPhoneMobileAppLinkURL;
    }

    public void setWindowsPhoneMobileAppLinkURL(String windowsPhoneMobileAppLinkURL) {
        this.windowsPhoneMobileAppLinkURL = windowsPhoneMobileAppLinkURL;
    }

    public Boolean getEnableiOSDownloadLink() {
        return this.enableiOSDownloadLink;
    }

    public void setEnableiOSDownloadLink(Boolean enableiOSDownloadLink) {
        this.enableiOSDownloadLink = enableiOSDownloadLink;
    }

    public Boolean getEnableAndroidDownloadLink() {
        return this.enableAndroidDownloadLink;
    }

    public void setEnableAndroidDownloadLink(Boolean enableAndroidDownloadLink) {
        this.enableAndroidDownloadLink = enableAndroidDownloadLink;
    }

    public Boolean getEnableWindowsPhoneDownloadLink() {
        return this.enableWindowsPhoneDownloadLink;
    }

    public void setEnableWindowsPhoneDownloadLink(Boolean enableWindowsPhoneDownloadLink) {
        this.enableWindowsPhoneDownloadLink = enableWindowsPhoneDownloadLink;
    }

    public Boolean getEnableWindowsDownloadLink() {
        return this.enableWindowsDownloadLink;
    }

    public void setEnableWindowsDownloadLink(Boolean enableWindowsDownloadLink) {
        this.enableWindowsDownloadLink = enableWindowsDownloadLink;
    }

    public Boolean getEnableMacDownloadLink() {
        return this.enableMacDownloadLink;
    }

    public void setEnableMacDownloadLink(Boolean enableMacDownloadLink) {
        this.enableMacDownloadLink = enableMacDownloadLink;
    }

    public Boolean getEnableOutlookDownloadLink() {
        return this.enableOutlookDownloadLink;
    }

    public void setEnableOutlookDownloadLink(Boolean enableOutlookDownloadLink) {
        this.enableOutlookDownloadLink = enableOutlookDownloadLink;
    }

    private static class V300
    extends ConfigSettings {
        private V300() {
        }

        private V300(FssApiVersion apiVersion, Long maxFileUploadSize, String iOSAppURL, String androidAppURL, String windowsPhoneMobileAppLinkURL, Boolean enableiOSDownloadLink, Boolean enableAndroidDownloadLink, Boolean enableWindowsPhoneDownloadLink, Boolean enableWindowsDownloadLink, Boolean enableMacDownloadLink, Boolean enableOutlookDownloadLink) {
            super(maxFileUploadSize, iOSAppURL, androidAppURL, windowsPhoneMobileAppLinkURL, enableiOSDownloadLink, enableAndroidDownloadLink, enableWindowsPhoneDownloadLink, enableWindowsDownloadLink, enableMacDownloadLink, enableOutlookDownloadLink);
        }
    }
}

