/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.Entry;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class ConflictListing
extends BaseFssApiResource {
    @Schema(description="A list of conflict files in the user's HCP Anywhere", required=true)
    private List<Entry> entries;

    public static Class<? extends ConflictListing> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V300.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static ConflictListing create(FssApiVersion apiVersion, List<Entry> entries) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V300(entries);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private ConflictListing(List<Entry> entries) {
        this.entries = entries;
    }

    private ConflictListing() {
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    private static class V300
    extends ConflictListing {
        private V300() {
        }

        private V300(List<Entry> entries) {
            super(entries);
        }
    }
}

