/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.InputStreamReader;

public abstract class DeletePathRequest
extends BaseFssApiResource {
    @Schema(description="The path of the file or folder", required=true)
    private String path;
    @Schema(description="The etag of the file or folder to delete. The etag identifies the version of the file or folder and is part of the file or folder metadata.", required=true)
    private String etag;
    @Schema(description="This parameter only applies to deleting a folder. If true, all the files and folders within the given folder are deleted.")
    private Boolean recursive;

    public static Class<? extends DeletePathRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static DeletePathRequest create(FssApiVersion apiVersion, String path, Boolean recursive, String etag) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(path, recursive, etag);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static DeletePathRequest create(FssApiVersion apiVersion, InputStreamReader reader) throws AwJsonException, AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return DeletePathRequest.fromJson(apiVersion, reader, V211.class);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private DeletePathRequest() {
    }

    private DeletePathRequest(String path, Boolean recursive, String etag) {
        this.path = path;
        this.recursive = recursive;
        this.etag = etag;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
        this.validateFieldNotNull("path", this.path, fieldName);
        this.validateFieldNotNull("etag", this.etag, fieldName);
    }

    public String getPath() {
        return this.path;
    }

    public Boolean isRecursive() {
        return this.recursive;
    }

    public String getEtag() {
        return this.etag;
    }

    private static class V211
    extends DeletePathRequest {
        private V211() {
        }

        private V211(String path, Boolean recursive, String etag) {
            super(path, recursive, etag);
        }
    }
}

