/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public abstract class DownloadZipRequest
extends BaseFssApiResource {
    @Schema(description="The path to each item you want to download", required=true)
    private List<String> pathList;
    @Schema(description="The point in time at which to download the items. This needs to be supplied in Unix format in milliseconds.")
    private Long pointInTime;

    public static Class<? extends DownloadZipRequest> getFssApiClass(FssApiVersion apiVersion) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    public static DownloadZipRequest create(FssApiVersion apiVersion, List<String> pathList, Long pointInTime) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(pathList, pointInTime);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private DownloadZipRequest(List<String> pathList, Long pointInTime) {
        this.pathList = pathList;
        this.pointInTime = pointInTime;
    }

    @Override
    protected void validate(String fieldName, BaseFssApiResource parentRes) throws AwJsonException {
        this.validateFieldNotNull("paths", this.pathList, fieldName);
        if (this.pathList.isEmpty()) {
            throw new AwJsonException("Field 'pathList' cannot be empty");
        }
        if (this.pointInTime != null) {
            this.validateFieldInRange("pointInTime", this.pointInTime, 0L, Long.MAX_VALUE, fieldName);
        }
    }

    public List<String> getPathList() {
        return this.pathList;
    }

    public Long getPointInTime() {
        return this.pointInTime;
    }

    private static class V300
    extends DownloadZipRequest {
        private V300(List<String> pathList, Long pointInTime) {
            super(pathList, pointInTime);
        }
    }
}

