/*
 * Decompiled with CFR 0.152.
 */
package com.hds.hcpaw.fss.api.model;

import com.google.common.base.Objects;
import com.hds.hcpaw.fss.api.exception.AwJsonException;
import com.hds.hcpaw.fss.api.exception.AwUnsupportedApiVersionException;
import com.hds.hcpaw.fss.api.model.Access;
import com.hds.hcpaw.fss.api.model.BaseFssApiResource;
import com.hds.hcpaw.fss.api.model.EntryBackupInfo;
import com.hds.hcpaw.fss.api.model.EntrySharingInfo;
import com.hds.hcpaw.fss.api.model.EntryState;
import com.hds.hcpaw.fss.api.model.EntryType;
import com.hds.hcpaw.fss.api.version.FssApiVersion;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;

public abstract class Entry
extends BaseFssApiResource {
    @Schema(description="The type of item (FILE or FOLDER)")
    private EntryType type;
    @Schema(description="Parent of the entry")
    private String parent;
    @Schema(description="Name of the entry")
    private String name;
    @Schema(description="The time at which the file was last modified")
    private Long changeTime;
    @Schema(description="The time at which the file was created")
    private Long creationTime;
    @Schema(description="The size (in bytes) of the file")
    private Long size;
    @Schema(description="The hex encoded SHA-384 hash of the file")
    private String hash;
    @Schema(description="The type of operations the user can perform on the file")
    private Access access;
    @Schema(description="The etag of the file (identifies the version of the file)")
    private String etag;
    @Schema(description="The state of the file (CREATE or DELETE)")
    private EntryState state;
    @Schema(description="Additional information if file is uploaded into a shared folder, team folder, or mobilized share")
    private EntrySharingInfo sharing;
    @Schema(description="Additional information if the file is uploaded into a backup folder")
    private EntryBackupInfo backup;
    @Schema(description="The access time of the entry")
    private Long accessTime;
    @Schema(description="Whether or not the file is protected and cannot be modified")
    private Boolean worm;
    @Schema(description="The unique id of the entry")
    private String uniqueId;
    @Schema(description="The unique id of the entry's parent entry")
    private String parentUniqueId;

    public static Class<? extends Entry> getFssApiClass(FssApiVersion apiVersion) {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return V440.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_430)) {
            return V430.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return V420.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return V300.class;
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return V211.class;
        }
        throw new UnsupportedOperationException("Unsupported API version");
    }

    public static Entry create(FssApiVersion apiVersion, EntryType type, String parent, String name, String etag, Long changeTime, Long creationTime, Long size, String hash, Access access, EntryState state, EntrySharingInfo sharing, EntryBackupInfo backup, Long accessTime, Boolean worm, String uniqueId, String parentUniqueId) throws AwUnsupportedApiVersionException {
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_440)) {
            return new V440(type, parent, name, etag, changeTime, creationTime, size, hash, access, state, sharing, backup, accessTime, worm, uniqueId, parentUniqueId);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_430)) {
            return new V430(type, parent, name, etag, changeTime, creationTime, size, hash, access, state, sharing, backup, accessTime, worm);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_420)) {
            return new V420(type, parent, name, etag, changeTime, creationTime, size, hash, access, state, sharing, backup);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_300)) {
            return new V300(type, parent, name, etag, changeTime, size, hash, access, state, sharing, backup);
        }
        if (apiVersion.isGreaterThanOrEqualTo(FssApiVersion.VERSION_211)) {
            return new V211(type, parent, name, etag, changeTime, size, hash, access);
        }
        throw new AwUnsupportedApiVersionException("Unsupported API version");
    }

    private Entry(EntryType type, String parent, String name, String etag, Long changeTime, Long createTime, Long size, String hash, Access access, EntryState state, EntrySharingInfo sharing, EntryBackupInfo backup, Long accessTime, Boolean worm, String uniqueId, String parentUniqueId) {
        this.type = type;
        this.parent = parent;
        this.name = name;
        this.etag = etag;
        this.changeTime = changeTime;
        this.creationTime = createTime;
        this.size = size;
        this.hash = hash;
        this.access = access;
        this.state = state;
        this.sharing = sharing;
        this.backup = backup;
        this.accessTime = accessTime;
        this.worm = worm;
        this.uniqueId = uniqueId;
        this.parentUniqueId = parentUniqueId;
    }

    private Entry() {
    }

    public EntryType getType() {
        return this.type;
    }

    public String getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getChangeTime() {
        return this.changeTime;
    }

    public Long getSize() {
        return this.size;
    }

    public String getHash() {
        return this.hash;
    }

    public Access getAccess() {
        return this.access;
    }

    public String getEtag() {
        return this.etag;
    }

    @Hidden
    public boolean isFolder() {
        return EntryType.FOLDER == this.type;
    }

    public EntryState getState() {
        return this.state == null ? EntryState.CREATE : this.state;
    }

    public EntrySharingInfo getSharing() {
        return this.sharing;
    }

    public EntryBackupInfo getBackup() {
        return this.backup;
    }

    public Long getAccessTime() {
        return this.accessTime;
    }

    public Boolean isWORM() {
        return this.worm;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getParentUniqueId() {
        return this.parentUniqueId;
    }

    @Override
    public void validate(String fieldName, BaseFssApiResource parent) throws AwJsonException {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Entry)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Entry e = (Entry)o;
        return Objects.equal((Object)((Object)this.getAccess()), (Object)((Object)e.getAccess())) && Objects.equal((Object)this.getChangeTime(), (Object)e.getChangeTime()) && Objects.equal((Object)this.getCreationTime(), (Object)e.getCreationTime()) && Objects.equal((Object)this.getEtag(), (Object)e.getEtag()) && Objects.equal((Object)this.getHash(), (Object)e.getHash()) && Objects.equal((Object)this.getName(), (Object)e.getName()) && Objects.equal((Object)this.getParent(), (Object)e.getParent()) && Objects.equal((Object)this.getSize(), (Object)e.getSize()) && Objects.equal((Object)((Object)this.getState()), (Object)((Object)e.getState())) && Objects.equal((Object)((Object)this.getType()), (Object)((Object)e.getType())) && Objects.equal((Object)this.getBackup(), (Object)e.getBackup()) && Objects.equal((Object)this.getSharing(), (Object)e.getSharing()) && Objects.equal((Object)this.getAccessTime(), (Object)e.getAccessTime()) && Objects.equal((Object)this.isWORM(), (Object)e.isWORM()) && Objects.equal((Object)this.getUniqueId(), (Object)e.getUniqueId()) && Objects.equal((Object)this.getParentUniqueId(), (Object)e.getParentUniqueId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getAccess(), this.getChangeTime(), this.getCreationTime(), this.getEtag(), this.getHash(), this.getName(), this.getParent(), this.getSize(), this.getState(), this.getType(), this.getBackup(), this.getSharing(), this.getAccessTime(), this.isWORM(), this.getUniqueId(), this.getParentUniqueId()});
    }

    private static class V440
    extends Entry {
        public V440() {
        }

        public V440(EntryType type, String parent, String name, String etag, Long changeTime, Long creationTime, Long size, String hash, Access access, EntryState state, EntrySharingInfo sharing, EntryBackupInfo backup, Long accessTime, Boolean worm, String uniqueId, String parentUniqueId) {
            super(type, parent, name, etag, changeTime, creationTime, size, hash, access, state, sharing, backup, accessTime, worm, uniqueId, parentUniqueId);
        }
    }

    private static class V420
    extends Entry {
        private V420() {
        }

        private V420(EntryType type, String parent, String name, String etag, Long changeTime, Long creationTime, Long size, String hash, Access access, EntryState state, EntrySharingInfo sharing, EntryBackupInfo backup) {
            super(type, parent, name, etag, changeTime, creationTime, size, hash, access, state, sharing, backup, null, null, null, null);
        }
    }

    private static class V430
    extends Entry {
        public V430() {
        }

        public V430(EntryType type, String parent, String name, String etag, Long changeTime, Long creationTime, Long size, String hash, Access access, EntryState state, EntrySharingInfo sharing, EntryBackupInfo backup, Long accessTime, Boolean worm) {
            super(type, parent, name, etag, changeTime, creationTime, size, hash, access, state, sharing, backup, accessTime, worm, null, null);
        }
    }

    private static class V300
    extends Entry {
        private V300() {
        }

        private V300(EntryType type, String parent, String name, String etag, Long changeTime, Long size, String hash, Access access, EntryState state, EntrySharingInfo sharing, EntryBackupInfo backup) {
            super(type, parent, name, etag, changeTime, null, size, hash, access, state, sharing, backup, null, null, null, null);
        }
    }

    private static class V211
    extends Entry {
        private V211() {
        }

        private V211(EntryType type, String parent, String name, String etag, Long changeTime, Long size, String hash, Access access) {
            super(type, parent, name, etag, changeTime, null, size, hash, access, null, null, null, null, null, null, null);
        }
    }
}

